/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A textual message with a certain level.")
public class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="level")
    private LevelEnum level = null;
    @JsonProperty(value="text")
    private String text = null;
    @JsonProperty(value="key")
    private String key = null;

    public Message level(LevelEnum level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(value="The level of the message.")
    public LevelEnum getLevel() {
        return this.level;
    }

    public void setLevel(LevelEnum level) {
        this.level = level;
    }

    public Message text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="The actual message.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Message key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="A key for this message")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals((Object)this.level, (Object)message.level) && Objects.equals(this.text, message.text) && Objects.equals(this.key, message.key);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.level, this.text, this.key});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Message {\n");
        sb.append("    level: ").append(this.toIndentedString((Object)this.level)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LevelEnum {
        OK("OK"),
        NOTICE("NOTICE"),
        INVALID("INVALID"),
        ERROR("ERROR");

        private String value;

        private LevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LevelEnum fromValue(String text) {
            for (LevelEnum b : LevelEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

