/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.appng.api.rest.model.FieldValue;
import org.appng.api.rest.model.Link;

@ApiModel(description="A single element of a page.")
public class Element
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="fields")
    private List<FieldValue> fields = null;
    @JsonProperty(value="selected")
    private Boolean selected = null;
    @JsonProperty(value="links")
    private List<Link> links = null;

    public Element fields(List<FieldValue> fields) {
        this.fields = fields;
        return this;
    }

    public Element addFieldsItem(FieldValue fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldValue>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @ApiModelProperty(value="The list of field-values of the element.")
    public List<FieldValue> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldValue> fields) {
        this.fields = fields;
    }

    public Element selected(Boolean selected) {
        this.selected = selected;
        return this;
    }

    @ApiModelProperty(value="Whether this element is selected/active.")
    public Boolean isSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public Element links(List<Link> links) {
        this.links = links;
        return this;
    }

    public Element addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @ApiModelProperty(value="A list of links.")
    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Element element = (Element)o;
        return Objects.equals(this.fields, element.fields) && Objects.equals(this.selected, element.selected) && Objects.equals(this.links, element.links);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.selected, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Element {\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    selected: ").append(this.toIndentedString(this.selected)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

