/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.appng.api.rest.model.Element;
import org.appng.api.rest.model.Field;
import org.appng.api.rest.model.Filter;
import org.appng.api.rest.model.Link;
import org.appng.api.rest.model.Message;
import org.appng.api.rest.model.Page;
import org.appng.api.rest.model.Parameter;
import org.appng.api.rest.model.Permission;
import org.appng.api.rest.model.User;

@ApiModel(description="A datasource, represented by either a page (of elements) or a single element.")
public class Datasource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="parameters")
    private List<Parameter> parameters = null;
    @JsonProperty(value="user")
    private User user = null;
    @JsonProperty(value="links")
    private List<Link> links = null;
    @JsonProperty(value="messages")
    private List<Message> messages = null;
    @JsonProperty(value="fields")
    private List<Field> fields = null;
    @JsonProperty(value="filters")
    private List<Filter> filters = null;
    @JsonProperty(value="page")
    private Page page = null;
    @JsonProperty(value="element")
    private Element element = null;
    @JsonProperty(value="permissions")
    private List<Permission> permissions = null;

    public Datasource id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID of the datasource.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Datasource parameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Datasource addParametersItem(Parameter parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @ApiModelProperty(value="The parameters for the datasource.")
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Datasource user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="The current user.")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Datasource links(List<Link> links) {
        this.links = links;
        return this;
    }

    public Datasource addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @ApiModelProperty(value="A list of links.")
    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public Datasource messages(List<Message> messages) {
        this.messages = messages;
        return this;
    }

    public Datasource addMessagesItem(Message messagesItem) {
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        this.messages.add(messagesItem);
        return this;
    }

    @ApiModelProperty(value="A list of messages.")
    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public Datasource fields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    public Datasource addFieldsItem(Field fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<Field>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @ApiModelProperty(value="A list of fields.")
    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public Datasource filters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    public Datasource addFiltersItem(Filter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @ApiModelProperty(value="A list of filters.")
    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public Datasource page(Page page) {
        this.page = page;
        return this;
    }

    @ApiModelProperty(value="A page of elements.")
    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public Datasource element(Element element) {
        this.element = element;
        return this;
    }

    @ApiModelProperty(value="A single element.")
    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public Datasource permissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public Datasource addPermissionsItem(Permission permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<Permission>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(value="The permissions for this datasource.")
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Datasource datasource = (Datasource)o;
        return Objects.equals(this.id, datasource.id) && Objects.equals(this.parameters, datasource.parameters) && Objects.equals(this.user, datasource.user) && Objects.equals(this.links, datasource.links) && Objects.equals(this.messages, datasource.messages) && Objects.equals(this.fields, datasource.fields) && Objects.equals(this.filters, datasource.filters) && Objects.equals(this.page, datasource.page) && Objects.equals(this.element, datasource.element) && Objects.equals(this.permissions, datasource.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parameters, this.user, this.links, this.messages, this.fields, this.filters, this.page, this.element, this.permissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Datasource {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    element: ").append(this.toIndentedString(this.element)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

