/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.appng.api.rest.model.ActionField;
import org.appng.api.rest.model.Message;
import org.appng.api.rest.model.Parameter;
import org.appng.api.rest.model.Permission;
import org.appng.api.rest.model.User;

@ApiModel(description="An action, representing an executable operation.")
public class Action
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="event-id")
    private String eventId = null;
    @JsonProperty(value="parameters")
    private List<Parameter> parameters = null;
    @JsonProperty(value="user")
    private User user = null;
    @JsonProperty(value="messages")
    private List<Message> messages = null;
    @JsonProperty(value="fields")
    private List<ActionField> fields = null;
    @JsonProperty(value="permissions")
    private List<Permission> permissions = null;

    public Action id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The Id of the action.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Action eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(value="The event-Id of the action.")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public Action parameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Action addParametersItem(Parameter parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @ApiModelProperty(value="A list of parameters for the action")
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Action user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="The current user.")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Action messages(List<Message> messages) {
        this.messages = messages;
        return this;
    }

    public Action addMessagesItem(Message messagesItem) {
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        this.messages.add(messagesItem);
        return this;
    }

    @ApiModelProperty(value="A list of messages.")
    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public Action fields(List<ActionField> fields) {
        this.fields = fields;
        return this;
    }

    public Action addFieldsItem(ActionField fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<ActionField>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @ApiModelProperty(value="A list of action-fields.")
    public List<ActionField> getFields() {
        return this.fields;
    }

    public void setFields(List<ActionField> fields) {
        this.fields = fields;
    }

    public Action permissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public Action addPermissionsItem(Permission permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<Permission>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(value="The permissions for this action.")
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        return Objects.equals(this.id, action.id) && Objects.equals(this.eventId, action.eventId) && Objects.equals(this.parameters, action.parameters) && Objects.equals(this.user, action.user) && Objects.equals(this.messages, action.messages) && Objects.equals(this.fields, action.fields) && Objects.equals(this.permissions, action.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.eventId, this.parameters, this.user, this.messages, this.fields, this.permissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Action {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

