/*
 * appNG REST API
 * The REST API for appNG
 *
 * OpenAPI spec version: 1.0.0
 * Contact: matthias.mueller@appng.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.appng.api.rest.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.appng.api.rest.model.Element;
import java.io.Serializable;

/**
 * A page that contains paging information an a list of elements.
 */
@ApiModel(description = "A page that contains paging information an a list of elements.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2021-11-03T12:18:24.395+01:00")
public class Page implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("number")
  private Integer number = null;

  @JsonProperty("size")
  private Integer size = null;

  @JsonProperty("totalPages")
  private Integer totalPages = null;

  @JsonProperty("totalElements")
  private Integer totalElements = null;

  @JsonProperty("isFirst")
  private Boolean isFirst = null;

  @JsonProperty("isLast")
  private Boolean isLast = null;

  @JsonProperty("elements")
  private List<Element> elements = null;

  public Page number(Integer number) {
    this.number = number;
    return this;
  }

   /**
   * The 0-based number of the current page.
   * @return number
  **/
  @ApiModelProperty(value = "The 0-based number of the current page.")
  public Integer getNumber() {
    return number;
  }

  public void setNumber(Integer number) {
    this.number = number;
  }

  public Page size(Integer size) {
    this.size = size;
    return this;
  }

   /**
   * The number of elements per page.
   * @return size
  **/
  @ApiModelProperty(value = "The number of elements per page.")
  public Integer getSize() {
    return size;
  }

  public void setSize(Integer size) {
    this.size = size;
  }

  public Page totalPages(Integer totalPages) {
    this.totalPages = totalPages;
    return this;
  }

   /**
   * The number of total pages.
   * @return totalPages
  **/
  @ApiModelProperty(value = "The number of total pages.")
  public Integer getTotalPages() {
    return totalPages;
  }

  public void setTotalPages(Integer totalPages) {
    this.totalPages = totalPages;
  }

  public Page totalElements(Integer totalElements) {
    this.totalElements = totalElements;
    return this;
  }

   /**
   * The total number of elements.
   * @return totalElements
  **/
  @ApiModelProperty(value = "The total number of elements.")
  public Integer getTotalElements() {
    return totalElements;
  }

  public void setTotalElements(Integer totalElements) {
    this.totalElements = totalElements;
  }

  public Page isFirst(Boolean isFirst) {
    this.isFirst = isFirst;
    return this;
  }

   /**
   * If this is the first page.
   * @return isFirst
  **/
  @ApiModelProperty(value = "If this is the first page.")
  public Boolean isIsFirst() {
    return isFirst;
  }

  public void setIsFirst(Boolean isFirst) {
    this.isFirst = isFirst;
  }

  public Page isLast(Boolean isLast) {
    this.isLast = isLast;
    return this;
  }

   /**
   * If this is the last page.
   * @return isLast
  **/
  @ApiModelProperty(value = "If this is the last page.")
  public Boolean isIsLast() {
    return isLast;
  }

  public void setIsLast(Boolean isLast) {
    this.isLast = isLast;
  }

  public Page elements(List<Element> elements) {
    this.elements = elements;
    return this;
  }

  public Page addElementsItem(Element elementsItem) {
    if (this.elements == null) {
      this.elements = new ArrayList<Element>();
    }
    this.elements.add(elementsItem);
    return this;
  }

   /**
   * The elements of this page.
   * @return elements
  **/
  @ApiModelProperty(value = "The elements of this page.")
  public List<Element> getElements() {
    return elements;
  }

  public void setElements(List<Element> elements) {
    this.elements = elements;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Page page = (Page) o;
    return Objects.equals(this.number, page.number) &&
        Objects.equals(this.size, page.size) &&
        Objects.equals(this.totalPages, page.totalPages) &&
        Objects.equals(this.totalElements, page.totalElements) &&
        Objects.equals(this.isFirst, page.isFirst) &&
        Objects.equals(this.isLast, page.isLast) &&
        Objects.equals(this.elements, page.elements);
  }

  @Override
  public int hashCode() {
    return Objects.hash(number, size, totalPages, totalElements, isFirst, isLast, elements);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Page {\n");
    
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    totalPages: ").append(toIndentedString(totalPages)).append("\n");
    sb.append("    totalElements: ").append(toIndentedString(totalElements)).append("\n");
    sb.append("    isFirst: ").append(toIndentedString(isFirst)).append("\n");
    sb.append("    isLast: ").append(toIndentedString(isLast)).append("\n");
    sb.append("    elements: ").append(toIndentedString(elements)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

