/*
 * appNG REST API
 * The REST API for appNG
 *
 * OpenAPI spec version: 1.0.0
 * Contact: matthias.mueller@appng.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.appng.api.rest.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.appng.api.rest.model.ActionField;
import org.appng.api.rest.model.FieldType;
import org.appng.api.rest.model.Message;
import org.appng.api.rest.model.Options;
import org.appng.api.rest.model.ValidationRule;
import java.io.Serializable;

/**
 * A single field as a part of an action.
 */
@ApiModel(description = "A single field as a part of an action.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2021-11-03T12:18:24.395+01:00")
public class ActionField implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("value")
  private Object value = null;

  @JsonProperty("label")
  private String label = null;

  @JsonProperty("fieldType")
  private FieldType fieldType = null;

  @JsonProperty("readonly")
  private Boolean readonly = null;

  @JsonProperty("visible")
  private Boolean visible = null;

  @JsonProperty("format")
  private String format = null;

  @JsonProperty("formattedValue")
  private String formattedValue = null;

  @JsonProperty("options")
  private Options options = null;

  @JsonProperty("rules")
  private List<ValidationRule> rules = null;

  @JsonProperty("messages")
  private List<Message> messages = null;

  @JsonProperty("fields")
  private List<ActionField> fields = null;

  public ActionField name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the field.
   * @return name
  **/
  @ApiModelProperty(value = "The name of the field.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ActionField value(Object value) {
    this.value = value;
    return this;
  }

   /**
   * The value of the field. The concrete type of that object depends on the fieldType of this field.
   * @return value
  **/
  @ApiModelProperty(value = "The value of the field. The concrete type of that object depends on the fieldType of this field.")
  public Object getValue() {
    return value;
  }

  public void setValue(Object value) {
    this.value = value;
  }

  public ActionField label(String label) {
    this.label = label;
    return this;
  }

   /**
   * The label for the field.
   * @return label
  **/
  @ApiModelProperty(value = "The label for the field.")
  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public ActionField fieldType(FieldType fieldType) {
    this.fieldType = fieldType;
    return this;
  }

   /**
   * The type for the field.
   * @return fieldType
  **/
  @ApiModelProperty(value = "The type for the field.")
  public FieldType getFieldType() {
    return fieldType;
  }

  public void setFieldType(FieldType fieldType) {
    this.fieldType = fieldType;
  }

  public ActionField readonly(Boolean readonly) {
    this.readonly = readonly;
    return this;
  }

   /**
   * Whether or not this field is read-only.
   * @return readonly
  **/
  @ApiModelProperty(value = "Whether or not this field is read-only.")
  public Boolean isReadonly() {
    return readonly;
  }

  public void setReadonly(Boolean readonly) {
    this.readonly = readonly;
  }

  public ActionField visible(Boolean visible) {
    this.visible = visible;
    return this;
  }

   /**
   * Whether or not this field should be visible.
   * @return visible
  **/
  @ApiModelProperty(value = "Whether or not this field should be visible.")
  public Boolean isVisible() {
    return visible;
  }

  public void setVisible(Boolean visible) {
    this.visible = visible;
  }

  public ActionField format(String format) {
    this.format = format;
    return this;
  }

   /**
   * The format for this field, depending on its type.
   * @return format
  **/
  @ApiModelProperty(value = "The format for this field, depending on its type.")
  public String getFormat() {
    return format;
  }

  public void setFormat(String format) {
    this.format = format;
  }

  public ActionField formattedValue(String formattedValue) {
    this.formattedValue = formattedValue;
    return this;
  }

   /**
   * The formatted value for this field.
   * @return formattedValue
  **/
  @ApiModelProperty(value = "The formatted value for this field.")
  public String getFormattedValue() {
    return formattedValue;
  }

  public void setFormattedValue(String formattedValue) {
    this.formattedValue = formattedValue;
  }

  public ActionField options(Options options) {
    this.options = options;
    return this;
  }

   /**
   * The options for this filter.
   * @return options
  **/
  @ApiModelProperty(value = "The options for this filter.")
  public Options getOptions() {
    return options;
  }

  public void setOptions(Options options) {
    this.options = options;
  }

  public ActionField rules(List<ValidationRule> rules) {
    this.rules = rules;
    return this;
  }

  public ActionField addRulesItem(ValidationRule rulesItem) {
    if (this.rules == null) {
      this.rules = new ArrayList<ValidationRule>();
    }
    this.rules.add(rulesItem);
    return this;
  }

   /**
   * The validation rules that should be applied for this field.
   * @return rules
  **/
  @ApiModelProperty(value = "The validation rules that should be applied for this field.")
  public List<ValidationRule> getRules() {
    return rules;
  }

  public void setRules(List<ValidationRule> rules) {
    this.rules = rules;
  }

  public ActionField messages(List<Message> messages) {
    this.messages = messages;
    return this;
  }

  public ActionField addMessagesItem(Message messagesItem) {
    if (this.messages == null) {
      this.messages = new ArrayList<Message>();
    }
    this.messages.add(messagesItem);
    return this;
  }

   /**
   * The messages related to this field.
   * @return messages
  **/
  @ApiModelProperty(value = "The messages related to this field.")
  public List<Message> getMessages() {
    return messages;
  }

  public void setMessages(List<Message> messages) {
    this.messages = messages;
  }

  public ActionField fields(List<ActionField> fields) {
    this.fields = fields;
    return this;
  }

  public ActionField addFieldsItem(ActionField fieldsItem) {
    if (this.fields == null) {
      this.fields = new ArrayList<ActionField>();
    }
    this.fields.add(fieldsItem);
    return this;
  }

   /**
   * The child fields of this fieldValue.
   * @return fields
  **/
  @ApiModelProperty(value = "The child fields of this fieldValue.")
  public List<ActionField> getFields() {
    return fields;
  }

  public void setFields(List<ActionField> fields) {
    this.fields = fields;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActionField actionField = (ActionField) o;
    return Objects.equals(this.name, actionField.name) &&
        Objects.equals(this.value, actionField.value) &&
        Objects.equals(this.label, actionField.label) &&
        Objects.equals(this.fieldType, actionField.fieldType) &&
        Objects.equals(this.readonly, actionField.readonly) &&
        Objects.equals(this.visible, actionField.visible) &&
        Objects.equals(this.format, actionField.format) &&
        Objects.equals(this.formattedValue, actionField.formattedValue) &&
        Objects.equals(this.options, actionField.options) &&
        Objects.equals(this.rules, actionField.rules) &&
        Objects.equals(this.messages, actionField.messages) &&
        Objects.equals(this.fields, actionField.fields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, value, label, fieldType, readonly, visible, format, formattedValue, options, rules, messages, fields);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActionField {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    fieldType: ").append(toIndentedString(fieldType)).append("\n");
    sb.append("    readonly: ").append(toIndentedString(readonly)).append("\n");
    sb.append("    visible: ").append(toIndentedString(visible)).append("\n");
    sb.append("    format: ").append(toIndentedString(format)).append("\n");
    sb.append("    formattedValue: ").append(toIndentedString(formattedValue)).append("\n");
    sb.append("    options: ").append(toIndentedString(options)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

