/*
 * appNG REST API
 * The REST API for appNG
 *
 * OpenAPI spec version: 1.0.0
 * Contact: matthias.mueller@appng.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.appng.api.rest.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

/**
 * A textual message with a certain level.
 */
@ApiModel(description = "A textual message with a certain level.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2020-10-05T13:14:35.071+02:00")
public class Message implements Serializable {
  private static final long serialVersionUID = 1L;

  /**
   * The level of the message.
   */
  public enum LevelEnum {
    OK("OK"),
    
    NOTICE("NOTICE"),
    
    INVALID("INVALID"),
    
    ERROR("ERROR");

    private String value;

    LevelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LevelEnum fromValue(String text) {
      for (LevelEnum b : LevelEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("level")
  private LevelEnum level = null;

  @JsonProperty("text")
  private String text = null;

  @JsonProperty("key")
  private String key = null;

  public Message level(LevelEnum level) {
    this.level = level;
    return this;
  }

   /**
   * The level of the message.
   * @return level
  **/
  @ApiModelProperty(value = "The level of the message.")
  public LevelEnum getLevel() {
    return level;
  }

  public void setLevel(LevelEnum level) {
    this.level = level;
  }

  public Message text(String text) {
    this.text = text;
    return this;
  }

   /**
   * The actual message.
   * @return text
  **/
  @ApiModelProperty(value = "The actual message.")
  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }

  public Message key(String key) {
    this.key = key;
    return this;
  }

   /**
   * A key for this message
   * @return key
  **/
  @ApiModelProperty(value = "A key for this message")
  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Message message = (Message) o;
    return Objects.equals(this.level, message.level) &&
        Objects.equals(this.text, message.text) &&
        Objects.equals(this.key, message.key);
  }

  @Override
  public int hashCode() {
    return Objects.hash(level, text, key);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Message {\n");
    
    sb.append("    level: ").append(toIndentedString(level)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

