/*
 * appNG REST API
 * The REST API for appNG
 *
 * OpenAPI spec version: 1.0.0
 * Contact: matthias.mueller@appng.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.appng.api.rest.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.appng.api.rest.model.Field;
import org.appng.api.rest.model.FieldType;
import org.appng.api.rest.model.Sort;
import org.appng.api.rest.model.ValidationRule;
import java.io.Serializable;

/**
 * A field that is part of a datasource.
 */
@ApiModel(description = "A field that is part of a datasource.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-09-24T08:50:35.297+02:00")
public class Field implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("label")
  private String label = null;

  @JsonProperty("fieldType")
  private FieldType fieldType = null;

  @JsonProperty("sort")
  private Sort sort = null;

  @JsonProperty("format")
  private String format = null;

  @JsonProperty("rules")
  private List<ValidationRule> rules = null;

  @JsonProperty("fields")
  private List<Field> fields = null;

  public Field name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name for this field.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "The name for this field.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Field label(String label) {
    this.label = label;
    return this;
  }

   /**
   * The label for this field.
   * @return label
  **/
  @ApiModelProperty(value = "The label for this field.")
  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public Field fieldType(FieldType fieldType) {
    this.fieldType = fieldType;
    return this;
  }

   /**
   * The type for this field.
   * @return fieldType
  **/
  @ApiModelProperty(required = true, value = "The type for this field.")
  public FieldType getFieldType() {
    return fieldType;
  }

  public void setFieldType(FieldType fieldType) {
    this.fieldType = fieldType;
  }

  public Field sort(Sort sort) {
    this.sort = sort;
    return this;
  }

   /**
   * The sort for this field.
   * @return sort
  **/
  @ApiModelProperty(value = "The sort for this field.")
  public Sort getSort() {
    return sort;
  }

  public void setSort(Sort sort) {
    this.sort = sort;
  }

  public Field format(String format) {
    this.format = format;
    return this;
  }

   /**
   * The format for this field, depending on its type.
   * @return format
  **/
  @ApiModelProperty(value = "The format for this field, depending on its type.")
  public String getFormat() {
    return format;
  }

  public void setFormat(String format) {
    this.format = format;
  }

  public Field rules(List<ValidationRule> rules) {
    this.rules = rules;
    return this;
  }

  public Field addRulesItem(ValidationRule rulesItem) {
    if (this.rules == null) {
      this.rules = new ArrayList<ValidationRule>();
    }
    this.rules.add(rulesItem);
    return this;
  }

   /**
   * The validation rules that should be applied for this field.
   * @return rules
  **/
  @ApiModelProperty(value = "The validation rules that should be applied for this field.")
  public List<ValidationRule> getRules() {
    return rules;
  }

  public void setRules(List<ValidationRule> rules) {
    this.rules = rules;
  }

  public Field fields(List<Field> fields) {
    this.fields = fields;
    return this;
  }

  public Field addFieldsItem(Field fieldsItem) {
    if (this.fields == null) {
      this.fields = new ArrayList<Field>();
    }
    this.fields.add(fieldsItem);
    return this;
  }

   /**
   * The child fields of this field.
   * @return fields
  **/
  @ApiModelProperty(value = "The child fields of this field.")
  public List<Field> getFields() {
    return fields;
  }

  public void setFields(List<Field> fields) {
    this.fields = fields;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Field field = (Field) o;
    return Objects.equals(this.name, field.name) &&
        Objects.equals(this.label, field.label) &&
        Objects.equals(this.fieldType, field.fieldType) &&
        Objects.equals(this.sort, field.sort) &&
        Objects.equals(this.format, field.format) &&
        Objects.equals(this.rules, field.rules) &&
        Objects.equals(this.fields, field.fields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, label, fieldType, sort, format, rules, fields);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Field {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    fieldType: ").append(toIndentedString(fieldType)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    format: ").append(toIndentedString(format)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

