/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A single option, used in a filter or an action-field.")
public class Option
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="label")
    private String label = null;
    @JsonProperty(value="selected")
    private Boolean selected = null;
    @JsonProperty(value="hits")
    private Integer hits = null;
    @JsonProperty(value="options")
    private List<Option> options = null;

    public Option value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The value for this option.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Option label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(value="The label for this option.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Option selected(Boolean selected) {
        this.selected = selected;
        return this;
    }

    @ApiModelProperty(value="Whether or not this option is selected.")
    public Boolean isSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public Option hits(Integer hits) {
        this.hits = hits;
        return this;
    }

    @ApiModelProperty(value="Tells how many hits there are for this option.")
    public Integer getHits() {
        return this.hits;
    }

    public void setHits(Integer hits) {
        this.hits = hits;
    }

    public Option options(List<Option> options) {
        this.options = options;
        return this;
    }

    public Option addOptionsItem(Option optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<Option>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @ApiModelProperty(value="An option can act as a group and thus can itself own a list of options.")
    public List<Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        return Objects.equals(this.value, option.value) && Objects.equals(this.label, option.label) && Objects.equals(this.selected, option.selected) && Objects.equals(this.hits, option.hits) && Objects.equals(this.options, option.options);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.label, this.selected, this.hits, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Option {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    selected: ").append(this.toIndentedString(this.selected)).append("\n");
        sb.append("    hits: ").append(this.toIndentedString(this.hits)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

