/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A link.")
public class Link
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="label")
    private String label = null;
    @JsonProperty(value="target")
    private String target = null;
    @JsonProperty(value="icon")
    private String icon = null;
    @JsonProperty(value="default")
    private Boolean _default = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="confirmation")
    private String confirmation = null;

    public Link id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID for this link.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Link label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(value="The label for the link.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Link target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(value="The target for the link.")
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Link icon(String icon) {
        this.icon = icon;
        return this;
    }

    @ApiModelProperty(value="A descriptive name for an icon that should be used for this link.")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Link _default(Boolean _default) {
        this._default = _default;
        return this;
    }

    @ApiModelProperty(value="Whether or not this link should be considered as default.")
    public Boolean isDefault() {
        return this._default;
    }

    public void setDefault(Boolean _default) {
        this._default = _default;
    }

    public Link type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of this link.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Link confirmation(String confirmation) {
        this.confirmation = confirmation;
        return this;
    }

    @ApiModelProperty(value="A confirmation message that should be displayed to the user before following this link.")
    public String getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(String confirmation) {
        this.confirmation = confirmation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.id, link.id) && Objects.equals(this.label, link.label) && Objects.equals(this.target, link.target) && Objects.equals(this.icon, link.icon) && Objects.equals(this._default, link._default) && Objects.equals((Object)this.type, (Object)link.type) && Objects.equals(this.confirmation, link.confirmation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.label, this.target, this.icon, this._default, this.type, this.confirmation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Link {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    icon: ").append(this.toIndentedString(this.icon)).append("\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    confirmation: ").append(this.toIndentedString(this.confirmation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        INTERN("intern"),
        EXTERN("extern"),
        WEBSERVICE("webservice"),
        REST("rest");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

