/*
 * appNG REST API
 * The REST API for appNG
 *
 * OpenAPI spec version: 1.0.0
 * Contact: matthias.mueller@appng.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.appng.api.rest.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

/**
 * A link.
 */
@ApiModel(description = "A link.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-05-03T09:25:55.332+02:00")
public class Link implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("label")
  private String label = null;

  @JsonProperty("target")
  private String target = null;

  @JsonProperty("icon")
  private String icon = null;

  @JsonProperty("default")
  private Boolean _default = null;

  /**
   * The type of this link.
   */
  public enum TypeEnum {
    INTERN("intern"),
    
    EXTERN("extern"),
    
    WEBSERVICE("webservice"),
    
    REST("rest");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("type")
  private TypeEnum type = null;

  @JsonProperty("confirmation")
  private String confirmation = null;

  public Link id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The ID for this link.
   * @return id
  **/
  @ApiModelProperty(value = "The ID for this link.")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Link label(String label) {
    this.label = label;
    return this;
  }

   /**
   * The label for the link.
   * @return label
  **/
  @ApiModelProperty(value = "The label for the link.")
  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public Link target(String target) {
    this.target = target;
    return this;
  }

   /**
   * The target for the link.
   * @return target
  **/
  @ApiModelProperty(value = "The target for the link.")
  public String getTarget() {
    return target;
  }

  public void setTarget(String target) {
    this.target = target;
  }

  public Link icon(String icon) {
    this.icon = icon;
    return this;
  }

   /**
   * A descriptive name for an icon that should be used for this link.
   * @return icon
  **/
  @ApiModelProperty(value = "A descriptive name for an icon that should be used for this link.")
  public String getIcon() {
    return icon;
  }

  public void setIcon(String icon) {
    this.icon = icon;
  }

  public Link _default(Boolean _default) {
    this._default = _default;
    return this;
  }

   /**
   * Whether or not this link should be considered as default.
   * @return _default
  **/
  @ApiModelProperty(value = "Whether or not this link should be considered as default.")
  public Boolean isDefault() {
    return _default;
  }

  public void setDefault(Boolean _default) {
    this._default = _default;
  }

  public Link type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * The type of this link.
   * @return type
  **/
  @ApiModelProperty(value = "The type of this link.")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public Link confirmation(String confirmation) {
    this.confirmation = confirmation;
    return this;
  }

   /**
   * A confirmation message that should be displayed to the user before following this link.
   * @return confirmation
  **/
  @ApiModelProperty(value = "A confirmation message that should be displayed to the user before following this link.")
  public String getConfirmation() {
    return confirmation;
  }

  public void setConfirmation(String confirmation) {
    this.confirmation = confirmation;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Link link = (Link) o;
    return Objects.equals(this.id, link.id) &&
        Objects.equals(this.label, link.label) &&
        Objects.equals(this.target, link.target) &&
        Objects.equals(this.icon, link.icon) &&
        Objects.equals(this._default, link._default) &&
        Objects.equals(this.type, link.type) &&
        Objects.equals(this.confirmation, link.confirmation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, label, target, icon, _default, type, confirmation);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Link {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    icon: ").append(toIndentedString(icon)).append("\n");
    sb.append("    _default: ").append(toIndentedString(_default)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    confirmation: ").append(toIndentedString(confirmation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

