/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appng.api.rest.RFC3339DateFormat;
import org.appng.api.rest.auth.ApiKeyAuth;
import org.appng.api.rest.auth.Authentication;
import org.appng.api.rest.auth.HttpBasicAuth;
import org.appng.api.rest.auth.OAuth;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="org.appng.api.rest.ApiClient")
public class ApiClient {
    private boolean debugging = false;
    private HttpHeaders defaultHeaders = new HttpHeaders();
    private String basePath = "http://appng.org/api";
    private RestTemplate restTemplate;
    private Map<String, Authentication> authentications;
    private HttpStatus statusCode;
    private MultiValueMap<String, String> responseHeaders;
    private DateFormat dateFormat;

    public ApiClient() {
        this.restTemplate = this.buildRestTemplate();
        this.init();
    }

    @Autowired
    public ApiClient(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.init();
    }

    protected void init() {
        this.dateFormat = new RFC3339DateFormat();
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setUserAgent("Java-SDK");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public MultiValueMap<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String name, String value) {
        if (this.defaultHeaders.containsKey((Object)name)) {
            this.defaultHeaders.remove((Object)name);
        }
        this.defaultHeaders.add(name, value);
        return this;
    }

    public void setDebugging(boolean debugging) {
        ArrayList<ApiClientHttpRequestInterceptor> currentInterceptors = this.restTemplate.getInterceptors();
        if (debugging) {
            if (currentInterceptors == null) {
                currentInterceptors = new ArrayList<ApiClientHttpRequestInterceptor>();
            }
            ApiClientHttpRequestInterceptor interceptor = new ApiClientHttpRequestInterceptor();
            currentInterceptors.add(interceptor);
            this.restTemplate.setInterceptors(currentInterceptors);
        } else if (currentInterceptors != null && !currentInterceptors.isEmpty()) {
            Iterator iter = currentInterceptors.iterator();
            while (iter.hasNext()) {
                ClientHttpRequestInterceptor interceptor = (ClientHttpRequestInterceptor)iter.next();
                if (!(interceptor instanceof ApiClientHttpRequestInterceptor)) continue;
                iter.remove();
            }
            this.restTemplate.setInterceptors(currentInterceptors);
        }
        this.debugging = debugging;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public MultiValueMap<String, String> parameterToMultiValueMap(CollectionFormat collectionFormat, String name, Object value) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if (collectionFormat == null) {
            collectionFormat = CollectionFormat.CSV;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add((Object)name, (Object)this.parameterToString(value));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        if (collectionFormat.equals((Object)CollectionFormat.MULTI)) {
            for (Object item : valueCollection) {
                params.add((Object)name, (Object)this.parameterToString(item));
            }
            return params;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Object o : valueCollection) {
            values.add(this.parameterToString(o));
        }
        params.add((Object)name, (Object)collectionFormat.collectionToString(values));
        return params;
    }

    public boolean isJsonMime(String mediaType) {
        if ("*/*".equals(mediaType)) {
            return true;
        }
        try {
            return this.isJsonMime(MediaType.parseMediaType((String)mediaType));
        }
        catch (InvalidMediaTypeException invalidMediaTypeException) {
            return false;
        }
    }

    public boolean isJsonMime(MediaType mediaType) {
        return mediaType != null && (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType) || mediaType.getSubtype().matches("^.*\\+json[;]?\\s*$"));
    }

    public List<MediaType> selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            MediaType mediaType = MediaType.parseMediaType((String)accept);
            if (!this.isJsonMime(mediaType)) continue;
            return Collections.singletonList(mediaType);
        }
        return MediaType.parseMediaTypes((String)StringUtils.arrayToCommaDelimitedString((Object[])accepts));
    }

    public MediaType selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return MediaType.APPLICATION_JSON;
        }
        for (String contentType : contentTypes) {
            MediaType mediaType = MediaType.parseMediaType((String)contentType);
            if (!this.isJsonMime(mediaType)) continue;
            return mediaType;
        }
        return MediaType.parseMediaType((String)contentTypes[0]);
    }

    protected Object selectBody(Object obj, MultiValueMap<String, Object> formParams, MediaType contentType) {
        boolean isForm = MediaType.MULTIPART_FORM_DATA.isCompatibleWith(contentType) || MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType);
        return isForm ? formParams : obj;
    }

    public <T> T invokeAPI(String path, HttpMethod method, MultiValueMap<String, String> queryParams, Object body, HttpHeaders headerParams, MultiValueMap<String, Object> formParams, List<MediaType> accept, MediaType contentType, String[] authNames, ParameterizedTypeReference<T> returnType) throws RestClientException {
        this.updateParamsForAuth(authNames, queryParams, headerParams);
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.basePath).path(path);
        if (queryParams != null) {
            builder.queryParams(queryParams);
        }
        RequestEntity.BodyBuilder requestBuilder = RequestEntity.method((HttpMethod)method, (URI)builder.build().toUri());
        if (accept != null) {
            requestBuilder.accept(accept.toArray(new MediaType[accept.size()]));
        }
        if (contentType != null) {
            requestBuilder.contentType(contentType);
        }
        this.addHeadersToRequest(headerParams, requestBuilder);
        this.addHeadersToRequest(this.defaultHeaders, requestBuilder);
        RequestEntity requestEntity = requestBuilder.body(this.selectBody(body, formParams, contentType));
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, returnType);
        this.statusCode = responseEntity.getStatusCode();
        this.responseHeaders = responseEntity.getHeaders();
        if (responseEntity.getStatusCode() == HttpStatus.NO_CONTENT) {
            return null;
        }
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (returnType == null) {
                return null;
            }
            return (T)responseEntity.getBody();
        }
        throw new RestClientException("API returned " + this.statusCode + " and it wasn't handled by the RestTemplate error handler");
    }

    protected void addHeadersToRequest(HttpHeaders headers, RequestEntity.BodyBuilder requestBuilder) {
        for (Map.Entry entry : headers.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                if (value == null) continue;
                requestBuilder.header((String)entry.getKey(), new String[]{value});
            }
        }
    }

    protected RestTemplate buildRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory(restTemplate.getRequestFactory()));
        return restTemplate;
    }

    private void updateParamsForAuth(String[] authNames, MultiValueMap<String, String> queryParams, HttpHeaders headerParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RestClientException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams);
        }
    }

    private class ApiClientHttpRequestInterceptor
    implements ClientHttpRequestInterceptor {
        private final Log log = LogFactory.getLog(ApiClientHttpRequestInterceptor.class);

        private ApiClientHttpRequestInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            this.logRequest(request, body);
            ClientHttpResponse response = execution.execute(request, body);
            this.logResponse(response);
            return response;
        }

        private void logRequest(HttpRequest request, byte[] body) throws UnsupportedEncodingException {
            this.log.info((Object)("URI: " + request.getURI()));
            this.log.info((Object)("HTTP Method: " + request.getMethod()));
            this.log.info((Object)("HTTP Headers: " + this.headersToString(request.getHeaders())));
            this.log.info((Object)("Request Body: " + new String(body, StandardCharsets.UTF_8)));
        }

        private void logResponse(ClientHttpResponse response) throws IOException {
            this.log.info((Object)("HTTP Status Code: " + response.getRawStatusCode()));
            this.log.info((Object)("Status Text: " + response.getStatusText()));
            this.log.info((Object)("HTTP Headers: " + this.headersToString(response.getHeaders())));
            this.log.info((Object)("Response Body: " + this.bodyToString(response.getBody())));
        }

        private String headersToString(HttpHeaders headers) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : headers.entrySet()) {
                builder.append((String)entry.getKey()).append("=[");
                for (String value : (List)entry.getValue()) {
                    builder.append(value).append(",");
                }
                builder.setLength(builder.length() - 1);
                builder.append("],");
            }
            builder.setLength(builder.length() - 1);
            return builder.toString();
        }

        private String bodyToString(InputStream body) throws IOException {
            StringBuilder builder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(body, StandardCharsets.UTF_8));
            String line = bufferedReader.readLine();
            while (line != null) {
                builder.append(line).append(System.lineSeparator());
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
            return builder.toString();
        }
    }

    public static enum CollectionFormat {
        CSV(","),
        TSV("\t"),
        SSV(" "),
        PIPES("|"),
        MULTI(null);

        private final String separator;

        private CollectionFormat(String separator) {
            this.separator = separator;
        }

        private String collectionToString(Collection<? extends CharSequence> collection) {
            return StringUtils.collectionToDelimitedString(collection, (String)this.separator);
        }
    }
}

