/*
 * appNG REST API
 * The REST API for appNG
 *
 * OpenAPI spec version: 1.0.0
 * Contact: matthias.mueller@appng.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.appng.api.rest.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.appng.api.rest.model.Parameter;
import java.io.Serializable;

/**
 * A validation rule that can be bound to an action-field.
 */
@ApiModel(description = "A validation rule that can be bound to an action-field.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-12-12T12:22:02.337+01:00")
public class ValidationRule implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("type")
  private String type = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("active")
  private Boolean active = null;

  @JsonProperty("messageKey")
  private String messageKey = null;

  @JsonProperty("options")
  private List<Parameter> options = null;

  public ValidationRule type(String type) {
    this.type = type;
    return this;
  }

   /**
   * The type of the rule.
   * @return type
  **/
  @ApiModelProperty(value = "The type of the rule.")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ValidationRule message(String message) {
    this.message = message;
    return this;
  }

   /**
   * The error message displayed when the rule isn&#39;t fulfilled.
   * @return message
  **/
  @ApiModelProperty(value = "The error message displayed when the rule isn't fulfilled.")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public ValidationRule active(Boolean active) {
    this.active = active;
    return this;
  }

   /**
   * Whether or not this rule is active, meaning it should be applied.
   * @return active
  **/
  @ApiModelProperty(value = "Whether or not this rule is active, meaning it should be applied.")
  public Boolean isActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  public ValidationRule messageKey(String messageKey) {
    this.messageKey = messageKey;
    return this;
  }

   /**
   * The message key for this rule
   * @return messageKey
  **/
  @ApiModelProperty(value = "The message key for this rule")
  public String getMessageKey() {
    return messageKey;
  }

  public void setMessageKey(String messageKey) {
    this.messageKey = messageKey;
  }

  public ValidationRule options(List<Parameter> options) {
    this.options = options;
    return this;
  }

  public ValidationRule addOptionsItem(Parameter optionsItem) {
    if (this.options == null) {
      this.options = new ArrayList<Parameter>();
    }
    this.options.add(optionsItem);
    return this;
  }

   /**
   * An array defining the custom parameters for this rule.
   * @return options
  **/
  @ApiModelProperty(value = "An array defining the custom parameters for this rule.")
  public List<Parameter> getOptions() {
    return options;
  }

  public void setOptions(List<Parameter> options) {
    this.options = options;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ValidationRule validationRule = (ValidationRule) o;
    return Objects.equals(this.type, validationRule.type) &&
        Objects.equals(this.message, validationRule.message) &&
        Objects.equals(this.active, validationRule.active) &&
        Objects.equals(this.messageKey, validationRule.messageKey) &&
        Objects.equals(this.options, validationRule.options);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, message, active, messageKey, options);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ValidationRule {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    messageKey: ").append(toIndentedString(messageKey)).append("\n");
    sb.append("    options: ").append(toIndentedString(options)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

