/*
 * appNG REST API
 * The REST API for appNG
 *
 * OpenAPI spec version: 1.0.0
 * Contact: matthias.mueller@appng.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.appng.api.rest.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.appng.api.rest.model.Option;
import java.io.Serializable;

/**
 * A single option, used in a filter or an action-field.
 */
@ApiModel(description = "A single option, used in a filter or an action-field.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-12-12T12:22:02.337+01:00")
public class Option implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("value")
  private String value = null;

  @JsonProperty("label")
  private String label = null;

  @JsonProperty("selected")
  private Boolean selected = null;

  @JsonProperty("hits")
  private Integer hits = null;

  @JsonProperty("options")
  private List<Option> options = null;

  public Option value(String value) {
    this.value = value;
    return this;
  }

   /**
   * The value for this option.
   * @return value
  **/
  @ApiModelProperty(value = "The value for this option.")
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public Option label(String label) {
    this.label = label;
    return this;
  }

   /**
   * The label for this option.
   * @return label
  **/
  @ApiModelProperty(value = "The label for this option.")
  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public Option selected(Boolean selected) {
    this.selected = selected;
    return this;
  }

   /**
   * Whether or not this option is selected.
   * @return selected
  **/
  @ApiModelProperty(value = "Whether or not this option is selected.")
  public Boolean isSelected() {
    return selected;
  }

  public void setSelected(Boolean selected) {
    this.selected = selected;
  }

  public Option hits(Integer hits) {
    this.hits = hits;
    return this;
  }

   /**
   * Tells how many hits there are for this option.
   * @return hits
  **/
  @ApiModelProperty(value = "Tells how many hits there are for this option.")
  public Integer getHits() {
    return hits;
  }

  public void setHits(Integer hits) {
    this.hits = hits;
  }

  public Option options(List<Option> options) {
    this.options = options;
    return this;
  }

  public Option addOptionsItem(Option optionsItem) {
    if (this.options == null) {
      this.options = new ArrayList<Option>();
    }
    this.options.add(optionsItem);
    return this;
  }

   /**
   * An option can act as a group and thus can itself own a list of options.
   * @return options
  **/
  @ApiModelProperty(value = "An option can act as a group and thus can itself own a list of options.")
  public List<Option> getOptions() {
    return options;
  }

  public void setOptions(List<Option> options) {
    this.options = options;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Option option = (Option) o;
    return Objects.equals(this.value, option.value) &&
        Objects.equals(this.label, option.label) &&
        Objects.equals(this.selected, option.selected) &&
        Objects.equals(this.hits, option.hits) &&
        Objects.equals(this.options, option.options);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, label, selected, hits, options);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Option {\n");
    
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    selected: ").append(toIndentedString(selected)).append("\n");
    sb.append("    hits: ").append(toIndentedString(hits)).append("\n");
    sb.append("    options: ").append(toIndentedString(options)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

