/*
 * appNG REST API
 * The REST API for appNG
 *
 * OpenAPI spec version: 1.0.0
 * Contact: matthias.mueller@appng.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.appng.api.rest.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.appng.api.rest.model.Element;
import org.appng.api.rest.model.Field;
import org.appng.api.rest.model.Filter;
import org.appng.api.rest.model.Link;
import org.appng.api.rest.model.Message;
import org.appng.api.rest.model.Page;
import org.appng.api.rest.model.Parameter;
import org.appng.api.rest.model.Permission;
import org.appng.api.rest.model.User;
import java.io.Serializable;

/**
 * A datasource, represented by either a page (of elements) or a single element.
 */
@ApiModel(description = "A datasource, represented by either a page (of elements) or a single element.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-12-12T12:22:02.337+01:00")
public class Datasource implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("parameters")
  private List<Parameter> parameters = null;

  @JsonProperty("user")
  private User user = null;

  @JsonProperty("links")
  private List<Link> links = null;

  @JsonProperty("messages")
  private List<Message> messages = null;

  @JsonProperty("fields")
  private List<Field> fields = null;

  @JsonProperty("filters")
  private List<Filter> filters = null;

  @JsonProperty("page")
  private Page page = null;

  @JsonProperty("element")
  private Element element = null;

  @JsonProperty("permissions")
  private List<Permission> permissions = null;

  public Datasource id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The unique ID of the datasource.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "The unique ID of the datasource.")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Datasource parameters(List<Parameter> parameters) {
    this.parameters = parameters;
    return this;
  }

  public Datasource addParametersItem(Parameter parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<Parameter>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

   /**
   * The parameters for the datasource.
   * @return parameters
  **/
  @ApiModelProperty(value = "The parameters for the datasource.")
  public List<Parameter> getParameters() {
    return parameters;
  }

  public void setParameters(List<Parameter> parameters) {
    this.parameters = parameters;
  }

  public Datasource user(User user) {
    this.user = user;
    return this;
  }

   /**
   * The current user.
   * @return user
  **/
  @ApiModelProperty(value = "The current user.")
  public User getUser() {
    return user;
  }

  public void setUser(User user) {
    this.user = user;
  }

  public Datasource links(List<Link> links) {
    this.links = links;
    return this;
  }

  public Datasource addLinksItem(Link linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<Link>();
    }
    this.links.add(linksItem);
    return this;
  }

   /**
   * A list of links.
   * @return links
  **/
  @ApiModelProperty(value = "A list of links.")
  public List<Link> getLinks() {
    return links;
  }

  public void setLinks(List<Link> links) {
    this.links = links;
  }

  public Datasource messages(List<Message> messages) {
    this.messages = messages;
    return this;
  }

  public Datasource addMessagesItem(Message messagesItem) {
    if (this.messages == null) {
      this.messages = new ArrayList<Message>();
    }
    this.messages.add(messagesItem);
    return this;
  }

   /**
   * A list of messages.
   * @return messages
  **/
  @ApiModelProperty(value = "A list of messages.")
  public List<Message> getMessages() {
    return messages;
  }

  public void setMessages(List<Message> messages) {
    this.messages = messages;
  }

  public Datasource fields(List<Field> fields) {
    this.fields = fields;
    return this;
  }

  public Datasource addFieldsItem(Field fieldsItem) {
    if (this.fields == null) {
      this.fields = new ArrayList<Field>();
    }
    this.fields.add(fieldsItem);
    return this;
  }

   /**
   * A list of fields.
   * @return fields
  **/
  @ApiModelProperty(value = "A list of fields.")
  public List<Field> getFields() {
    return fields;
  }

  public void setFields(List<Field> fields) {
    this.fields = fields;
  }

  public Datasource filters(List<Filter> filters) {
    this.filters = filters;
    return this;
  }

  public Datasource addFiltersItem(Filter filtersItem) {
    if (this.filters == null) {
      this.filters = new ArrayList<Filter>();
    }
    this.filters.add(filtersItem);
    return this;
  }

   /**
   * A list of filters.
   * @return filters
  **/
  @ApiModelProperty(value = "A list of filters.")
  public List<Filter> getFilters() {
    return filters;
  }

  public void setFilters(List<Filter> filters) {
    this.filters = filters;
  }

  public Datasource page(Page page) {
    this.page = page;
    return this;
  }

   /**
   * A page of elements.
   * @return page
  **/
  @ApiModelProperty(value = "A page of elements.")
  public Page getPage() {
    return page;
  }

  public void setPage(Page page) {
    this.page = page;
  }

  public Datasource element(Element element) {
    this.element = element;
    return this;
  }

   /**
   * A single element.
   * @return element
  **/
  @ApiModelProperty(value = "A single element.")
  public Element getElement() {
    return element;
  }

  public void setElement(Element element) {
    this.element = element;
  }

  public Datasource permissions(List<Permission> permissions) {
    this.permissions = permissions;
    return this;
  }

  public Datasource addPermissionsItem(Permission permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new ArrayList<Permission>();
    }
    this.permissions.add(permissionsItem);
    return this;
  }

   /**
   * The permissions for this datasource.
   * @return permissions
  **/
  @ApiModelProperty(value = "The permissions for this datasource.")
  public List<Permission> getPermissions() {
    return permissions;
  }

  public void setPermissions(List<Permission> permissions) {
    this.permissions = permissions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Datasource datasource = (Datasource) o;
    return Objects.equals(this.id, datasource.id) &&
        Objects.equals(this.parameters, datasource.parameters) &&
        Objects.equals(this.user, datasource.user) &&
        Objects.equals(this.links, datasource.links) &&
        Objects.equals(this.messages, datasource.messages) &&
        Objects.equals(this.fields, datasource.fields) &&
        Objects.equals(this.filters, datasource.filters) &&
        Objects.equals(this.page, datasource.page) &&
        Objects.equals(this.element, datasource.element) &&
        Objects.equals(this.permissions, datasource.permissions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, parameters, user, links, messages, fields, filters, page, element, permissions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Datasource {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("    filters: ").append(toIndentedString(filters)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    element: ").append(toIndentedString(element)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

