/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import guideme.color.LightDarkMode;
import guideme.internal.scene.FakeRenderEnvironment;
import guideme.scene.CameraSettings;
import guideme.scene.GuidebookLightmap;
import guideme.scene.LiquidVertexConsumer;
import guideme.scene.SodiumCompat;
import guideme.scene.annotation.InWorldAnnotation;
import guideme.scene.annotation.InWorldAnnotationRenderer;
import guideme.scene.level.GuidebookLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class GuidebookLevelRenderer {
    private static GuidebookLevelRenderer instance;
    private final GuidebookLightmap lightmap = new GuidebookLightmap();

    public static GuidebookLevelRenderer getInstance() {
        RenderSystem.assertOnRenderThread();
        if (instance == null) {
            instance = new GuidebookLevelRenderer();
        }
        return instance;
    }

    public void render(GuidebookLevel level, CameraSettings cameraSettings, Collection<InWorldAnnotation> annotations, LightDarkMode lightDarkMode) {
        this.lightmap.update(level);
        level.onRenderFrame();
        RenderSystem.setShaderGameTime((long)level.getGameTime(), (float)level.getPartialTick());
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        this.render(level, cameraSettings, buffers, annotations, lightDarkMode);
        buffers.endBatch();
    }

    public void render(GuidebookLevel level, CameraSettings cameraSettings, MultiBufferSource.BufferSource buffers, Collection<InWorldAnnotation> annotations, LightDarkMode lightDarkMode) {
        this.lightmap.update(level);
        LevelLightEngine lightEngine = level.getLightEngine();
        while (lightEngine.hasLightWork()) {
            lightEngine.runLightUpdates();
        }
        Matrix4f projectionMatrix = cameraSettings.getProjectionMatrix();
        Matrix4f viewMatrix = cameraSettings.getViewMatrix();
        RenderSystem.setShaderFog((FogParameters)FogParameters.NO_FOG);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.identity();
        modelViewStack.mul((Matrix4fc)viewMatrix);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        Vector4f lightDirection = new Vector4f(0.16666667f, 0.35f, 1.0f, 0.0f);
        Matrix4f lightTransform = new Matrix4f((Matrix4fc)viewMatrix);
        lightTransform.invert();
        lightTransform.transform(lightDirection);
        Lighting.setupLevel();
        this.renderContent(level, buffers);
        InWorldAnnotationRenderer.render(buffers, annotations, lightDarkMode);
        modelViewStack.popMatrix();
        RenderSystem.restoreProjectionMatrix();
        Lighting.setupFor3DItems();
    }

    public void renderContent(GuidebookLevel level, MultiBufferSource.BufferSource buffers) {
        try (FakeRenderEnvironment fake = FakeRenderEnvironment.create(level);){
            this.renderBlocks(level, (MultiBufferSource)buffers, false);
            this.renderBlockEntities(level, (MultiBufferSource)buffers, level.getPartialTick());
            this.renderEntities(level, buffers, level.getPartialTick());
            buffers.endBatch(RenderType.entitySolid((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            buffers.endBatch(RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            buffers.endBatch(RenderType.entityCutoutNoCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            buffers.endBatch(RenderType.entitySmoothCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            for (RenderType layer : RenderType.chunkBufferLayers()) {
                if (layer == RenderType.translucent()) continue;
                buffers.endBatch(layer);
            }
            buffers.endBatch(RenderType.solid());
            buffers.endBatch(RenderType.endPortal());
            buffers.endBatch(RenderType.endGateway());
            buffers.endBatch(Sheets.solidBlockSheet());
            buffers.endBatch(Sheets.cutoutBlockSheet());
            buffers.endBatch(Sheets.bedSheet());
            buffers.endBatch(Sheets.shulkerBoxSheet());
            buffers.endBatch(Sheets.signSheet());
            buffers.endBatch(Sheets.hangingSignSheet());
            buffers.endBatch(Sheets.chestSheet());
            buffers.endLastBatch();
            this.renderBlocks(level, (MultiBufferSource)buffers, true);
            buffers.endBatch(RenderType.translucent());
        }
    }

    private void renderBlocks(GuidebookLevel level, MultiBufferSource buffers, boolean translucent) {
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.getInstance().getBlockRenderer();
        PoseStack poseStack = new PoseStack();
        SingleThreadedRandomSource randomSource = new SingleThreadedRandomSource(0L);
        ArrayList<BlockModelPart> modelParts = new ArrayList<BlockModelPart>();
        Iterator it = level.getFilledBlocks().iterator();
        while (it.hasNext()) {
            RenderType renderType;
            BlockPos pos = (BlockPos)it.next();
            BlockState blockState = level.getBlockState(pos);
            FluidState fluidState = blockState.getFluidState();
            if (!fluidState.isEmpty() && ((renderType = ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState)) != RenderType.translucent() || translucent)) {
                VertexConsumer bufferBuilder = buffers.getBuffer(renderType);
                SectionPos sectionPos = SectionPos.of((BlockPos)pos);
                LiquidVertexConsumer liquidVertexConsumer = new LiquidVertexConsumer(bufferBuilder, sectionPos);
                blockRenderDispatcher.renderLiquid(pos, (BlockAndTintGetter)level, (VertexConsumer)liquidVertexConsumer, blockState, fluidState);
                GuidebookLevelRenderer.markFluidSpritesActive(fluidState);
            }
            if (blockState.getRenderShape() == RenderShape.INVISIBLE) continue;
            BlockStateModel model = blockRenderDispatcher.getBlockModel(blockState);
            modelParts.clear();
            randomSource.setSeed(blockState.getSeed(pos));
            model.collectParts((BlockAndTintGetter)level, pos, blockState, (RandomSource)randomSource, modelParts);
            if (!translucent) {
                modelParts.removeIf(part -> part.getRenderType(blockState).getRenderPipeline().getBlendFunction().isPresent());
            }
            poseStack.pushPose();
            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            blockRenderDispatcher.renderBatched(blockState, pos, (BlockAndTintGetter)level, poseStack, arg_0 -> ((MultiBufferSource)buffers).getBuffer(arg_0), true, modelParts);
            poseStack.popPose();
        }
    }

    private void renderBlockEntities(GuidebookLevel level, MultiBufferSource buffers, float partialTick) {
        PoseStack poseStack = new PoseStack();
        Iterator it = level.getFilledBlocks().iterator();
        while (it.hasNext()) {
            BlockEntity blockEntity;
            BlockPos pos = (BlockPos)it.next();
            BlockState blockState = level.getBlockState(pos);
            if (!blockState.hasBlockEntity() || (blockEntity = level.getBlockEntity(pos)) == null) continue;
            this.handleBlockEntity(poseStack, blockEntity, buffers, partialTick);
        }
    }

    private static void markFluidSpritesActive(FluidState fluidState) {
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((FluidState)fluidState);
        TextureAtlasSprite sprite1 = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(props.getStillTexture());
        SodiumCompat.markSpriteActive(sprite1);
        TextureAtlasSprite sprite2 = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(props.getFlowingTexture());
        SodiumCompat.markSpriteActive(sprite2);
    }

    private <E extends BlockEntity> void handleBlockEntity(PoseStack stack, E blockEntity, MultiBufferSource buffers, float partialTicks) {
        BlockEntityRenderDispatcher dispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
        BlockEntityRenderer renderer = dispatcher.getRenderer(blockEntity);
        if (renderer != null && renderer.shouldRender(blockEntity, blockEntity.getBlockPos().getCenter())) {
            BlockPos pos = blockEntity.getBlockPos();
            stack.pushPose();
            stack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
            renderer.render(blockEntity, partialTicks, stack, buffers, packedLight, OverlayTexture.NO_OVERLAY, Vec3.ZERO);
            stack.popPose();
        }
    }

    private void renderEntities(GuidebookLevel level, MultiBufferSource.BufferSource buffers, float partialTick) {
        PoseStack poseStack = new PoseStack();
        for (Entity entity : level.getEntitiesForRendering()) {
            this.handleEntity(level, poseStack, entity, (MultiBufferSource)buffers, partialTick);
        }
    }

    private <E extends Entity> void handleEntity(GuidebookLevel level, PoseStack poseStack, E entity, MultiBufferSource buffers, float partialTicks) {
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer renderer = dispatcher.getRenderer(entity);
        if (renderer == null) {
            return;
        }
        GuidebookLevelRenderer.renderEntity(level, poseStack, entity, buffers, partialTicks, renderer);
    }

    private static <E extends Entity, S extends EntityRenderState> void renderEntity(GuidebookLevel level, PoseStack poseStack, E entity, MultiBufferSource buffers, float partialTicks, EntityRenderer<? super E, S> renderer) {
        BlockPos probePos = BlockPos.containing((Position)entity.getLightProbePosition(partialTicks));
        int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)probePos);
        Vec3 pos = entity.position();
        EntityRenderState state = renderer.createRenderState(entity, partialTicks);
        Vec3 offset = renderer.getRenderOffset(state);
        poseStack.pushPose();
        poseStack.translate(pos.x + offset.x(), pos.y + offset.y(), pos.z + offset.z());
        renderer.render(state, poseStack, buffers, packedLight);
        poseStack.popPose();
    }
}

