/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.util;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import guideme.document.LytRect;
import guideme.internal.util.DashPattern;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public final class DashedRectangle {
    private DashedRectangle() {
    }

    public static void render(PoseStack stack, LytRect bounds, DashPattern pattern, float z) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float t = 0.0f;
        if (pattern.animationCycleMs() > 0.0f) {
            t = (float)(System.currentTimeMillis() % (long)((int)pattern.animationCycleMs())) / pattern.animationCycleMs();
        }
        DashedRectangle.buildHorizontalDashedLine(builder, stack, t, bounds.x(), bounds.right(), bounds.y(), z, pattern, false);
        DashedRectangle.buildHorizontalDashedLine(builder, stack, t, bounds.x(), bounds.right(), (float)bounds.bottom() - pattern.width(), z, pattern, true);
        DashedRectangle.buildVerticalDashedLine(builder, stack, t, bounds.x(), bounds.y(), bounds.bottom(), z, pattern, true);
        DashedRectangle.buildVerticalDashedLine(builder, stack, t, (float)bounds.right() - pattern.width(), bounds.y(), bounds.bottom(), z, pattern, false);
        RenderType.gui().draw(builder.buildOrThrow());
    }

    private static void buildHorizontalDashedLine(BufferBuilder builder, PoseStack stack, float t, float x1, float x2, float y, float z, DashPattern pattern, boolean reverse) {
        if (!reverse) {
            t = 1.0f - t;
        }
        float phase = t * pattern.length();
        Matrix4f pose = stack.last().pose();
        int color = pattern.color();
        for (float x = x1 - phase; x < x2; x += pattern.length()) {
            builder.addVertex(pose, Mth.clamp((float)(x + pattern.onLength()), (float)x1, (float)x2), y, z).setColor(color);
            builder.addVertex(pose, Mth.clamp((float)x, (float)x1, (float)x2), y, z).setColor(color);
            builder.addVertex(pose, Mth.clamp((float)x, (float)x1, (float)x2), y + pattern.width(), z).setColor(color);
            builder.addVertex(pose, Mth.clamp((float)(x + pattern.onLength()), (float)x1, (float)x2), y + pattern.width(), z).setColor(color);
        }
    }

    private static void buildVerticalDashedLine(BufferBuilder builder, PoseStack stack, float t, float x, float y1, float y2, float z, DashPattern pattern, boolean reverse) {
        if (!reverse) {
            t = 1.0f - t;
        }
        float phase = t * pattern.length();
        Matrix4f pose = stack.last().pose();
        int color = pattern.color();
        for (float y = y1 - phase; y < y2; y += pattern.length()) {
            builder.addVertex(pose, x + pattern.width(), Mth.clamp((float)y, (float)y1, (float)y2), z).setColor(color);
            builder.addVertex(pose, x, Mth.clamp((float)y, (float)y1, (float)y2), z).setColor(color);
            builder.addVertex(pose, x, Mth.clamp((float)(y + pattern.onLength()), (float)y1, (float)y2), z).setColor(color);
            builder.addVertex(pose, x + pattern.width(), Mth.clamp((float)(y + pattern.onLength()), (float)y1, (float)y2), z).setColor(color);
        }
    }
}

