/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.snakeyaml;

import guideme.internal.shaded.snakeyaml.DumperOptions;
import guideme.internal.shaded.snakeyaml.LoaderOptions;
import guideme.internal.shaded.snakeyaml.composer.Composer;
import guideme.internal.shaded.snakeyaml.constructor.BaseConstructor;
import guideme.internal.shaded.snakeyaml.constructor.Constructor;
import guideme.internal.shaded.snakeyaml.error.YAMLException;
import guideme.internal.shaded.snakeyaml.parser.ParserImpl;
import guideme.internal.shaded.snakeyaml.reader.StreamReader;
import guideme.internal.shaded.snakeyaml.representer.Representer;
import guideme.internal.shaded.snakeyaml.resolver.Resolver;

public class Yaml {
    protected final Resolver resolver;
    private String name;
    protected BaseConstructor constructor;
    protected Representer representer;
    protected DumperOptions dumperOptions;
    protected LoaderOptions loadingConfig;

    public Yaml() {
        this(new Constructor(new LoaderOptions()), new Representer(new DumperOptions()));
    }

    public Yaml(BaseConstructor constructor) {
        this(constructor, new Representer(new DumperOptions()));
    }

    public Yaml(BaseConstructor constructor, Representer representer) {
        this(constructor, representer, Yaml.initDumperOptions(representer));
    }

    private static DumperOptions initDumperOptions(Representer representer) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(representer.getDefaultFlowStyle());
        dumperOptions.setDefaultScalarStyle(representer.getDefaultScalarStyle());
        dumperOptions.setAllowReadOnlyProperties(representer.getPropertyUtils().isAllowReadOnlyProperties());
        dumperOptions.setTimeZone(representer.getTimeZone());
        return dumperOptions;
    }

    public Yaml(BaseConstructor constructor, Representer representer, DumperOptions dumperOptions) {
        this(constructor, representer, dumperOptions, new LoaderOptions(), new Resolver());
    }

    public Yaml(BaseConstructor constructor, Representer representer, DumperOptions dumperOptions, LoaderOptions loadingConfig, Resolver resolver) {
        if (!constructor.isExplicitPropertyUtils()) {
            constructor.setPropertyUtils(representer.getPropertyUtils());
        } else if (!representer.isExplicitPropertyUtils()) {
            representer.setPropertyUtils(constructor.getPropertyUtils());
        }
        this.constructor = constructor;
        this.constructor.setAllowDuplicateKeys(loadingConfig.isAllowDuplicateKeys());
        this.constructor.setWrappedToRootException(loadingConfig.isWrappedToRootException());
        if (!dumperOptions.getIndentWithIndicator() && dumperOptions.getIndent() <= dumperOptions.getIndicatorIndent()) {
            throw new YAMLException("Indicator indent must be smaller then indent.");
        }
        representer.setDefaultFlowStyle(dumperOptions.getDefaultFlowStyle());
        representer.setDefaultScalarStyle(dumperOptions.getDefaultScalarStyle());
        representer.getPropertyUtils().setAllowReadOnlyProperties(dumperOptions.isAllowReadOnlyProperties());
        representer.setTimeZone(dumperOptions.getTimeZone());
        this.representer = representer;
        this.dumperOptions = dumperOptions;
        this.loadingConfig = loadingConfig;
        this.resolver = resolver;
        this.name = "Yaml:" + System.identityHashCode(this);
    }

    public <T> T load(String yaml) {
        return (T)this.loadFromReader(new StreamReader(yaml), Object.class);
    }

    private Object loadFromReader(StreamReader sreader, Class<?> type) {
        Composer composer = new Composer(new ParserImpl(sreader, this.loadingConfig), this.resolver, this.loadingConfig);
        this.constructor.setComposer(composer);
        return this.constructor.getSingleData(type);
    }

    public String toString() {
        return this.name;
    }
}

