/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.methvin.watcher;

import guideme.internal.shaded.methvin.watcher.hashing.FileHash;
import guideme.internal.shaded.methvin.watcher.hashing.FileHasher;
import guideme.internal.shaded.methvin.watcher.visitor.FileTreeVisitor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class PathUtils {
    public static FileHash hash(FileHasher fileHasher, Path path) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return FileHash.directory();
            }
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            return fileHasher.hash(path);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static <T> SortedMap<Path, T> subMap(SortedMap<Path, T> sortedMap, Path path) {
        return sortedMap.subMap(path, Paths.get(path.toString(), "\uffff"));
    }

    public static SortedMap<Path, FileHash> createHashCodeMap(Path path2, FileHasher fileHasher, FileTreeVisitor fileTreeVisitor) throws IOException {
        ConcurrentSkipListMap<Path, FileHash> concurrentSkipListMap = new ConcurrentSkipListMap<Path, FileHash>();
        FileTreeVisitor.Callback callback = path -> {
            FileHash fileHash = PathUtils.hash(fileHasher, path);
            if (fileHash != null) {
                concurrentSkipListMap.put(path, fileHash);
            }
        };
        if (fileHasher != null) {
            fileTreeVisitor.recursiveVisitFiles(path2, callback, callback);
        }
        return concurrentSkipListMap;
    }

    public static void initWatcherState(List<Path> list, FileHasher fileHasher, FileTreeVisitor fileTreeVisitor, Map<Path, FileHash> map, Set<Path> set) throws IOException {
        for (Path path2 : list) {
            if (fileHasher == null) {
                fileTreeVisitor.recursiveVisitFiles(path2, set::add, path -> {});
                continue;
            }
            FileTreeVisitor.Callback callback = path -> {
                FileHash fileHash = PathUtils.hash(fileHasher, path);
                if (fileHash != null) {
                    map.put(path, fileHash);
                }
            };
            fileTreeVisitor.recursiveVisitFiles(path2, path -> {
                set.add(path);
                callback.call(path);
            }, callback);
        }
    }

    public static <T> WatchEvent<T> cast(WatchEvent<?> watchEvent) {
        return watchEvent;
    }
}

