/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.packed;

import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.LongValues;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;

public class MonotonicBlockPackedReader
extends LongValues
implements Accountable {
    final int blockShift;
    final int blockMask;
    final long valueCount;
    final long[] minValues;
    final float[] averages;
    final LongValues[] subReaders;
    final long sumBPV;
    final long totalByteCount;

    static long expected(long origin, float average, int index) {
        return origin + (long)(average * (float)index);
    }

    @Override
    public long get(long index) {
        assert (index >= 0L && index < this.valueCount);
        int block = (int)(index >>> this.blockShift);
        int idx = (int)(index & (long)this.blockMask);
        return MonotonicBlockPackedReader.expected(this.minValues[block], this.averages[block], idx) + this.subReaders[block].get(idx);
    }

    @Override
    public long ramBytesUsed() {
        long sizeInBytes = 0L;
        sizeInBytes += RamUsageEstimator.sizeOf(this.minValues);
        sizeInBytes += RamUsageEstimator.sizeOf(this.averages);
        return sizeInBytes += this.totalByteCount;
    }

    public String toString() {
        long avgBPV = this.subReaders.length == 0 ? 0L : this.sumBPV / (long)this.subReaders.length;
        return this.getClass().getSimpleName() + "(blocksize=" + (1 << this.blockShift) + ",size=" + this.valueCount + ",avgBPV=" + avgBPV + ")";
    }
}

