/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.Field;
import guideme.internal.shaded.lucene.document.FieldType;
import guideme.internal.shaded.lucene.document.InvertableType;
import guideme.internal.shaded.lucene.document.StoredValue;
import guideme.internal.shaded.lucene.index.IndexOptions;
import guideme.internal.shaded.lucene.index.IndexableFieldType;
import guideme.internal.shaded.lucene.util.BytesRef;

public final class StringField
extends Field {
    public static final FieldType TYPE_NOT_STORED = new FieldType();
    public static final FieldType TYPE_STORED = new FieldType();
    private BytesRef binaryValue;
    private final StoredValue storedValue;

    public StringField(String name, String value, Field.Store stored) {
        super(name, value, (IndexableFieldType)(stored == Field.Store.YES ? TYPE_STORED : TYPE_NOT_STORED));
        this.binaryValue = new BytesRef(value);
        this.storedValue = stored == Field.Store.YES ? new StoredValue(value) : null;
    }

    @Override
    public InvertableType invertableType() {
        return InvertableType.BINARY;
    }

    @Override
    public BytesRef binaryValue() {
        return this.binaryValue;
    }

    @Override
    public StoredValue storedValue() {
        return this.storedValue;
    }

    static {
        TYPE_NOT_STORED.setOmitNorms(true);
        TYPE_NOT_STORED.setIndexOptions(IndexOptions.DOCS);
        TYPE_NOT_STORED.setTokenized(false);
        TYPE_NOT_STORED.freeze();
        TYPE_STORED.setOmitNorms(true);
        TYPE_STORED.setIndexOptions(IndexOptions.DOCS);
        TYPE_STORED.setStored(true);
        TYPE_STORED.setTokenized(false);
        TYPE_STORED.freeze();
    }
}

