/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs;

import guideme.internal.shaded.lucene.codecs.KnnVectorsReader;
import guideme.internal.shaded.lucene.codecs.KnnVectorsWriter;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.SegmentReadState;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import guideme.internal.shaded.lucene.util.NamedSPILoader;
import java.io.IOException;

public abstract class KnnVectorsFormat
implements NamedSPILoader.NamedSPI {
    private final String name;
    public static final KnnVectorsFormat EMPTY = new KnnVectorsFormat("EMPTY"){

        @Override
        public KnnVectorsWriter fieldsWriter(SegmentWriteState state) {
            throw new UnsupportedOperationException("Attempt to write EMPTY vector values");
        }

        @Override
        public KnnVectorsReader fieldsReader(SegmentReadState state) {
            return new KnnVectorsReader(this){

                @Override
                public void checkIntegrity() {
                }

                @Override
                public FloatVectorValues getFloatVectorValues(String field) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ByteVectorValues getByteVectorValues(String field) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void close() {
                }
            };
        }

        @Override
        public int getMaxDimensions(String fieldName) {
            return 0;
        }
    };

    protected KnnVectorsFormat(String name) {
        NamedSPILoader.checkServiceName(name);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static KnnVectorsFormat forName(String name) {
        return Holder.getLoader().lookup(name);
    }

    public abstract KnnVectorsWriter fieldsWriter(SegmentWriteState var1) throws IOException;

    public abstract KnnVectorsReader fieldsReader(SegmentReadState var1) throws IOException;

    public abstract int getMaxDimensions(String var1);

    private static final class Holder {
        private static final NamedSPILoader<KnnVectorsFormat> LOADER = new NamedSPILoader<KnnVectorsFormat>(KnnVectorsFormat.class);

        static NamedSPILoader<KnnVectorsFormat> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a KnnVectorsFormat name before all formats could be initialized. This likely happens if you call KnnVectorsFormat#forName from a KnnVectorsFormat's ctor.");
            }
            return LOADER;
        }
    }
}

