/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.hi;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.LowerCaseFilter;
import guideme.internal.shaded.lucene.analysis.StopFilter;
import guideme.internal.shaded.lucene.analysis.StopwordAnalyzerBase;
import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.WordlistLoader;
import guideme.internal.shaded.lucene.analysis.core.DecimalDigitFilter;
import guideme.internal.shaded.lucene.analysis.hi.HindiNormalizationFilter;
import guideme.internal.shaded.lucene.analysis.hi.HindiStemFilter;
import guideme.internal.shaded.lucene.analysis.in.IndicNormalizationFilter;
import guideme.internal.shaded.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import guideme.internal.shaded.lucene.analysis.standard.StandardTokenizer;
import guideme.internal.shaded.lucene.util.IOUtils;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class HindiAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;

    public HindiAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    public HindiAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public HindiAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new DecimalDigitFilter(result);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new IndicNormalizationFilter(result);
        result = new HindiNormalizationFilter(result);
        result = new StopFilter(result, this.stopwords);
        result = new HindiStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new LowerCaseFilter(in);
        result = new DecimalDigitFilter(result);
        result = new IndicNormalizationFilter(result);
        result = new HindiNormalizationFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(HindiAnalyzer.class.getResourceAsStream("stopwords.txt"), "stopwords.txt"), "#");
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

