/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.scene;

import com.mojang.authlib.GameProfile;
import guideme.internal.util.Platform;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.telemetry.WorldSessionTelemetryManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.ServerLinks;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.jetbrains.annotations.Nullable;

public class FakeRenderEnvironment
implements AutoCloseable {
    private final LocalPlayer originalPlayer;

    private FakeRenderEnvironment(@Nullable LocalPlayer originalPlayer) {
        this.originalPlayer = originalPlayer;
    }

    public static FakeRenderEnvironment create(Level level) {
        Minecraft minecraft = Minecraft.getInstance();
        Camera camera = new Camera();
        minecraft.getEntityRenderDispatcher().prepare(level, camera, null);
        Connection connection = new Connection(PacketFlow.CLIENTBOUND);
        ClientPacketListener packetListener = new ClientPacketListener(minecraft, connection, new CommonListenerCookie(new GameProfile(UUID.randomUUID(), "Site Exporter"), new WorldSessionTelemetryManager((eventType, propertyAdder) -> {}, false, null, null), Platform.getClientRegistryAccess().freeze(), FeatureFlags.VANILLA_SET, null, null, null, Map.of(), null, Map.of(), new ServerLinks(List.of()), ConnectionType.NEOFORGE));
        ClientLevel.ClientLevelData levelData = new ClientLevel.ClientLevelData(Difficulty.NORMAL, false, false);
        Holder.Reference overworldType = (Holder.Reference)Platform.getClientRegistryAccess().lookupOrThrow(Registries.DIMENSION_TYPE).get(Level.OVERWORLD.location()).orElseThrow();
        LocalPlayer originalPlayer = minecraft.player;
        minecraft.player = new LocalPlayer(minecraft, new ClientLevel(packetListener, levelData, Level.OVERWORLD, (Holder)overworldType, 100, 100, null, false, 0L, 0), packetListener, new StatsCounter(), new ClientRecipeBook(), false, false);
        return new FakeRenderEnvironment(originalPlayer);
    }

    @Override
    public void close() {
        Minecraft.getInstance().player = this.originalPlayer;
    }
}

