/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.network;

import guideme.PageAnchor;
import guideme.internal.GuideME;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record OpenGuideRequest(ResourceLocation guideId, Optional<PageAnchor> pageAnchor) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenGuideRequest> TYPE = new CustomPacketPayload.Type(GuideME.makeId("open_guide"));
    public static final StreamCodec<FriendlyByteBuf, PageAnchor> ANCHOR_STREAM_CODEC = StreamCodec.of((buffer, value) -> {
        buffer.writeResourceLocation(value.pageId());
        buffer.writeNullable((Object)value.anchor(), (StreamEncoder)ByteBufCodecs.STRING_UTF8);
    }, buffer -> {
        ResourceLocation page = buffer.readResourceLocation();
        String fragment = (String)buffer.readNullable((StreamDecoder)ByteBufCodecs.STRING_UTF8);
        return new PageAnchor(page, fragment);
    });
    public static final StreamCodec<FriendlyByteBuf, OpenGuideRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, OpenGuideRequest::guideId, (StreamCodec)ByteBufCodecs.optional(ANCHOR_STREAM_CODEC), OpenGuideRequest::pageAnchor, OpenGuideRequest::new);

    public OpenGuideRequest(ResourceLocation guideId) {
        this(guideId, Optional.empty());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

