/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import guideme.Guide;
import guideme.GuideBuilder;
import guideme.color.SymbolicColorResolver;
import guideme.compiler.PageCompiler;
import guideme.compiler.ParsedGuidePage;
import guideme.internal.GuideME;
import guideme.internal.GuideMEClient;
import guideme.internal.GuideRegistry;
import guideme.internal.MutableGuide;
import guideme.internal.datadriven.DataDrivenGuide;
import guideme.internal.util.LangUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.metadata.language.LanguageMetadataSection;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GuideReloadListener
extends SimplePreparableReloadListener<Result> {
    public static final ResourceLocation ID = GuideME.makeId("guides");
    private static final Logger LOG = LoggerFactory.getLogger(GuideReloadListener.class);

    GuideReloadListener() {
    }

    protected Result prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.startTick();
        IdentityHashMap<ResourceLocation, Map<ResourceLocation, ParsedGuidePage>> guidePages = new IdentityHashMap<ResourceLocation, Map<ResourceLocation, ParsedGuidePage>>();
        String language = LangUtil.getCurrentLanguage();
        if (GuideMEClient.instance().isIgnoreTranslatedGuides()) {
            language = null;
        }
        Set<String> languages = GuideReloadListener.getAllLanguages(resourceManager);
        Map<ResourceLocation, MutableGuide> dataDrivenGuides = GuideReloadListener.loadDataDrivenGuides(resourceManager);
        for (MutableGuide guide : dataDrivenGuides.values()) {
            guidePages.put(guide.getId(), GuideReloadListener.loadPages(resourceManager, guide.getContentRootFolder(), guide.getDefaultLanguage(), language, languages));
        }
        for (MutableGuide guide : GuideRegistry.getStaticGuides()) {
            if (guidePages.containsKey(guide.getId())) continue;
            guidePages.put(guide.getId(), GuideReloadListener.loadPages(resourceManager, guide.getContentRootFolder(), guide.getDefaultLanguage(), language, languages));
        }
        profiler.endTick();
        return new Result(dataDrivenGuides, guidePages, languages);
    }

    private static Set<String> getAllLanguages(ResourceManager resourceManager) {
        HashSet<String> result = new HashSet<String>();
        Iterator it = resourceManager.listPacks().iterator();
        while (it.hasNext()) {
            try {
                LanguageMetadataSection section = (LanguageMetadataSection)((PackResources)it.next()).getMetadataSection(LanguageMetadataSection.TYPE);
                if (section == null) continue;
                result.addAll(section.languages().keySet());
            }
            catch (Exception exception) {}
        }
        return result;
    }

    protected void apply(Result result, ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.startTick();
        LOG.info("Data driven guides: {}", result.dataDrivenGuides.keySet());
        GuideRegistry.setDataDriven(result.dataDrivenGuides);
        for (MutableGuide guide : GuideRegistry.getAll()) {
            Map<ResourceLocation, ParsedGuidePage> pagesForGuide = result.guidePages.getOrDefault(guide.getId(), Map.of());
            profiler.push(guide.getId().toString());
            guide.setPages(pagesForGuide);
            profiler.pop();
        }
        profiler.endTick();
    }

    public String getName() {
        return "GuideME Reload Listener";
    }

    private static Map<ResourceLocation, MutableGuide> loadDataDrivenGuides(ResourceManager resourceManager) {
        HashMap dataDrivenGuideJsons = new HashMap();
        FileToIdConverter guideJsonIds = new FileToIdConverter("guideme_guides", ".json");
        SimpleJsonResourceReloadListener.scanDirectory((ResourceManager)resourceManager, (FileToIdConverter)guideJsonIds, (DynamicOps)JsonOps.INSTANCE, DataDrivenGuide.CODEC, dataDrivenGuideJsons);
        HashMap<ResourceLocation, MutableGuide> dataDrivenGuides = new HashMap<ResourceLocation, MutableGuide>();
        for (Map.Entry entry : dataDrivenGuideJsons.entrySet()) {
            ResourceLocation guideId = (ResourceLocation)entry.getKey();
            DataDrivenGuide guideSpec = (DataDrivenGuide)entry.getValue();
            GuideBuilder builder = Guide.builder(guideId).register(false).itemSettings(guideSpec.itemSettings()).defaultLanguage(guideSpec.defaultLanguage());
            if (!guideSpec.customColors().isEmpty()) {
                builder.extension(SymbolicColorResolver.EXTENSION_POINT, guideSpec.customColors()::get);
            }
            MutableGuide guide = (MutableGuide)builder.build();
            dataDrivenGuides.put(guideId, guide);
        }
        return dataDrivenGuides;
    }

    private static Map<ResourceLocation, ParsedGuidePage> loadPages(ResourceManager resourceManager, String contentRoot, String defaultLanguage, @Nullable String currentLanguage, Set<String> languages) {
        HashMap<ResourceLocation, ParsedGuidePage> pagesForGuide = new HashMap<ResourceLocation, ParsedGuidePage>();
        Map resources = resourceManager.listResources(contentRoot, location -> location.getPath().endsWith(".md"));
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation translatedResourceId;
            Resource translatedPage;
            ResourceLocation pageId = ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)((ResourceLocation)entry.getKey()).getPath().substring((contentRoot + "/").length()));
            Resource resource = (Resource)entry.getValue();
            if (LangUtil.getLangFromPageId(pageId, languages) != null) continue;
            String language = defaultLanguage;
            if (currentLanguage != null && (translatedPage = (Resource)resources.get(translatedResourceId = LangUtil.getTranslatedAsset(pageId, currentLanguage).withPrefix(contentRoot + "/"))) != null) {
                language = currentLanguage;
                resource = translatedPage;
            }
            String sourcePackId = resource.sourcePackId();
            try {
                InputStream in = resource.open();
                try {
                    pagesForGuide.put(pageId, PageCompiler.parse(sourcePackId, language, pageId, in));
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                LOG.error("Failed to load guidebook page {} from pack {}", new Object[]{pageId, sourcePackId, e});
            }
        }
        return pagesForGuide;
    }

    protected record Result(Map<ResourceLocation, MutableGuide> dataDrivenGuides, Map<ResourceLocation, Map<ResourceLocation, ParsedGuidePage>> guidePages, Set<String> languages) {
    }
}

