/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal;

import com.mojang.blaze3d.platform.Window;
import com.mojang.brigadier.CommandDispatcher;
import guideme.Guide;
import guideme.PageAnchor;
import guideme.color.LightDarkMode;
import guideme.internal.GuideME;
import guideme.internal.GuideMEClientProxy;
import guideme.internal.GuideOnStartup;
import guideme.internal.GuideRegistry;
import guideme.internal.GuideReloadListener;
import guideme.internal.MutableGuide;
import guideme.internal.command.GuideClientCommand;
import guideme.internal.command.StructureCommands;
import guideme.internal.data.GuideMELanguageProvider;
import guideme.internal.data.GuideMEModelProvider;
import guideme.internal.hotkey.OpenGuideHotkey;
import guideme.internal.item.GuideItemDispatchUnbaked;
import guideme.internal.screen.GlobalInMemoryHistory;
import guideme.internal.screen.GuideNavigation;
import guideme.internal.screen.GuideScreenHistory;
import guideme.internal.search.GuideSearch;
import guideme.internal.siteexport.SiteExportOnStartup;
import guideme.internal.util.Blitter;
import guideme.render.GuiAssets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterItemModelsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="guideme", dist={Dist.CLIENT})
public class GuideMEClient {
    private static final Logger LOG = LoggerFactory.getLogger(GuideMEClient.class);
    private static GuideMEClient INSTANCE;
    public static final ResourceLocation GUIDE_CLICK_ID;
    public static SoundEvent GUIDE_CLICK_EVENT;
    private final GuideSearch search = new GuideSearch();
    private RecipeMap recipeMap = RecipeMap.EMPTY;
    private Set<RecipeType<?>> availableRecipeTypes = Set.of();
    private final ClientConfig clientConfig = new ClientConfig();

    public GuideMEClient(ModContainer modContainer, IEventBus modBus) {
        INSTANCE = this;
        GuideME.PROXY = new GuideMEClientProxy();
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.clientConfig.spec, "guideme.toml");
        modBus.addListener(RegisterEvent.class, e -> {
            if (e.getRegistryKey() == Registries.SOUND_EVENT) {
                Registry.register((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)GUIDE_CLICK_ID, (Object)GUIDE_CLICK_EVENT);
            }
        });
        modBus.addListener(this::gatherData);
        modBus.addListener(this::registerHotkeys);
        modBus.addListener(this::registerItemModel);
        modBus.addListener(this::registerRenderPipelines);
        NeoForge.EVENT_BUS.addListener(this::registerClientCommands);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        modBus.addListener(this::resetSprites);
        OpenGuideHotkey.init();
        modBus.addListener(evt -> evt.addListener(GuideReloadListener.ID, (PreparableReloadListener)new GuideReloadListener()));
        NeoForge.EVENT_BUS.addListener(evt -> {
            this.search.processWork();
            this.processDevWatchers();
        });
        GuideOnStartup.init();
        SiteExportOnStartup.init();
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        NeoForge.EVENT_BUS.addListener(this::onReceiveRecipes);
        NeoForge.EVENT_BUS.addListener(this::onPlayerDisconnect);
    }

    private void onReceiveRecipes(RecipesReceivedEvent event) {
        this.recipeMap = event.getRecipeMap();
        this.availableRecipeTypes = Set.copyOf(event.getRecipeTypes());
    }

    private void onPlayerDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        this.recipeMap = RecipeMap.EMPTY;
        this.availableRecipeTypes = Set.of();
    }

    private void registerRenderPipelines(RegisterRenderPipelinesEvent event) {
        event.registerPipeline(Blitter.GUI_TEXTURED_OPAQUE);
    }

    private void registerItemModel(RegisterItemModelsEvent event) {
        event.register(GuideItemDispatchUnbaked.ID, GuideItemDispatchUnbaked.CODEC);
    }

    private void processDevWatchers() {
        for (MutableGuide guide : GuideRegistry.getAll()) {
            guide.tick();
        }
    }

    public static LightDarkMode currentLightDarkMode() {
        return LightDarkMode.LIGHT_MODE;
    }

    private void resetSprites(TextureAtlasStitchedEvent event) {
        if (event.getAtlas().location().equals((Object)GuiAssets.GUI_SPRITE_ATLAS)) {
            GuiAssets.resetSprites();
        }
    }

    private void registerHotkeys(RegisterKeyMappingsEvent e) {
        e.register(OpenGuideHotkey.getHotkey());
    }

    public static GuideMEClient instance() {
        return Objects.requireNonNull(INSTANCE, "Mod is not initialized");
    }

    private void registerClientCommands(RegisterClientCommandsEvent evt) {
        CommandDispatcher dispatcher = evt.getDispatcher();
        GuideClientCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private void registerCommands(RegisterCommandsEvent event) {
        StructureCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void gatherData(GatherDataEvent.Client event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        gen.addProvider(true, (DataProvider)new GuideMELanguageProvider(packOutput));
        gen.addProvider(true, (DataProvider)new GuideMEModelProvider(packOutput));
    }

    public boolean isShowDebugGuiOverlays() {
        return this.clientConfig.showDebugGuiOverlays.getAsBoolean();
    }

    public boolean isAdaptiveScalingEnabled() {
        return this.clientConfig.adaptiveScaling.getAsBoolean();
    }

    public boolean isIgnoreTranslatedGuides() {
        return this.clientConfig.ignoreTranslatedGuides.getAsBoolean();
    }

    public boolean isHideMissingRecipeErrors() {
        return this.clientConfig.hideMissingRecipeErrors.getAsBoolean();
    }

    public boolean isFullWidthLayout() {
        return this.clientConfig.fullWidthLayout.getAsBoolean();
    }

    public void setFullWidthLayout(boolean fullWidth) {
        if (fullWidth != this.isFullWidthLayout()) {
            this.clientConfig.fullWidthLayout.set((Object)fullWidth);
            this.clientConfig.spec.save();
            Minecraft minecraft = Minecraft.getInstance();
            Screen screen = minecraft.screen;
            if (screen != null) {
                Window window = minecraft.getWindow();
                screen.resize(minecraft, window.getGuiScaledWidth(), window.getGuiScaledHeight());
            }
        }
    }

    public static boolean openGuideAtPreviousPage(Guide guide, ResourceLocation initialPage) {
        try {
            GuideScreenHistory history = GlobalInMemoryHistory.get(guide);
            Optional<PageAnchor> historyPage = history.current();
            if (historyPage.isPresent()) {
                GuideNavigation.navigateTo(guide, historyPage.get());
            } else {
                GuideNavigation.navigateTo(guide, PageAnchor.page(initialPage));
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to open guide.", (Throwable)e);
            return false;
        }
    }

    public static boolean openGuideAtAnchor(Guide guide, PageAnchor anchor) {
        try {
            GuideNavigation.navigateTo(guide, anchor);
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to open guide at {}.", (Object)anchor, (Object)e);
            return false;
        }
    }

    public GuideSearch getSearch() {
        return this.search;
    }

    public RecipeMap getRecipeMap() {
        return this.recipeMap;
    }

    public boolean isRecipeTypeAvailable(RecipeType<?> recipeType) {
        return this.availableRecipeTypes.contains(recipeType);
    }

    static {
        GUIDE_CLICK_ID = GuideME.makeId("guide.click");
        GUIDE_CLICK_EVENT = SoundEvent.createVariableRangeEvent((ResourceLocation)GUIDE_CLICK_ID);
    }

    private static class ClientConfig {
        final ModConfigSpec spec;
        final ModConfigSpec.BooleanValue adaptiveScaling;
        final ModConfigSpec.BooleanValue showDebugGuiOverlays;
        final ModConfigSpec.BooleanValue fullWidthLayout;
        final ModConfigSpec.BooleanValue ignoreTranslatedGuides;
        final ModConfigSpec.BooleanValue hideMissingRecipeErrors;

        public ClientConfig() {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            builder.push("guides");
            this.ignoreTranslatedGuides = builder.comment("Never load translated guide pages for your current language.").define("ignoreTranslatedGuides", false);
            this.hideMissingRecipeErrors = builder.comment("Never show errors in guides when recipes can't be found (i.e. because they were hidden by a datapack).").define("hideMissingRecipeErrors", false);
            builder.pop();
            builder.push("gui");
            this.adaptiveScaling = builder.comment("Adapt GUI scaling for the Guide screen to fix Minecraft font issues at GUI scale 1 and 3.").define("adaptiveScaling", true);
            this.fullWidthLayout = builder.comment("Use the full width of the screen for the guide when it is opened.").define("fullWidthLayout", true);
            builder.pop();
            builder.push("debug");
            this.showDebugGuiOverlays = builder.comment("Show debugging overlays in GUI on mouse-over.").define("showDebugGuiOverlays", false);
            builder.pop();
            this.spec = builder.build();
        }
    }
}

