/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.export;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import guideme.scene.export.Mesh;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMaps;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

class MeshBuildingBufferSource
extends MultiBufferSource.BufferSource
implements AutoCloseable {
    private final List<Mesh> meshes = new ArrayList<Mesh>();

    public MeshBuildingBufferSource() {
        super(new ByteBufferBuilder(786432), (SequencedMap)Object2ObjectSortedMaps.emptyMap());
    }

    public List<Mesh> getMeshes() {
        return this.meshes;
    }

    public void endBatch(RenderType renderType) {
        BufferBuilder bufferBuilder = (BufferBuilder)this.startedBuilders.remove(renderType);
        if (bufferBuilder == null) {
            return;
        }
        try (MeshData buffer = bufferBuilder.build();){
            if (buffer != null) {
                MeshData.DrawState drawState = buffer.drawState();
                ByteBuffer vbSource = buffer.vertexBuffer();
                ByteBuffer vertexBuffer = ByteBuffer.allocate(vbSource.remaining()).order(ByteOrder.nativeOrder());
                vertexBuffer.put(vbSource);
                vertexBuffer.flip();
                ByteBuffer indexBuffer = null;
                ByteBuffer ibSource = buffer.indexBuffer();
                if (ibSource != null) {
                    indexBuffer = ByteBuffer.allocate(ibSource.remaining());
                    indexBuffer.put(ibSource);
                    indexBuffer.flip();
                }
                this.meshes.add(new Mesh(drawState, vertexBuffer, indexBuffer, renderType));
            }
        }
    }

    @Override
    public void close() {
        this.fixedBuffers.values().forEach(ByteBufferBuilder::close);
        this.sharedBuffer.close();
    }
}

