/*
 * Decompiled with CFR 0.152.
 */
package guideme.render;

import com.mojang.blaze3d.platform.NativeImage;
import guideme.document.LytSize;
import guideme.internal.GuideME;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.stb.STBImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuidePageTexture {
    private static final Logger LOG = LoggerFactory.getLogger(GuidePageTexture.class);
    private static final Map<GuidePageTexture, ResourceLocation> usedTextures = new IdentityHashMap<GuidePageTexture, ResourceLocation>();
    private final ResourceLocation id;
    private final ByteBuffer imageContent;
    private final LytSize size;

    public static GuidePageTexture missing() {
        return new GuidePageTexture(GuideME.makeId((String)"missing"), null);
    }

    private GuidePageTexture(ResourceLocation id, byte @Nullable [] imageContent) {
        this.id = Objects.requireNonNull(id, "id");
        if (imageContent == null) {
            this.imageContent = null;
            this.size = new LytSize(32, 32);
        } else {
            this.imageContent = ByteBuffer.allocateDirect(imageContent.length);
            this.imageContent.put(imageContent).flip();
            int[] xOut = new int[1];
            int[] yOut = new int[1];
            int[] compOut = new int[1];
            if (!STBImage.stbi_info_from_memory((ByteBuffer)this.imageContent, (int[])xOut, (int[])yOut, (int[])compOut)) {
                throw new IllegalArgumentException("Couldn't determine size of image " + String.valueOf(id) + ": " + STBImage.stbi_failure_reason());
            }
            this.size = new LytSize(xOut[0], yOut[0]);
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public LytSize getSize() {
        return this.size;
    }

    public static GuidePageTexture load(ResourceLocation id, byte[] imageContent) {
        try {
            return new GuidePageTexture(id, imageContent);
        }
        catch (Exception e) {
            LOG.error("Failed to get image {}: {}", (Object)id, (Object)e.toString());
            return GuidePageTexture.missing();
        }
    }

    public ResourceLocation use() {
        return usedTextures.computeIfAbsent(this, guidePageTexture -> {
            if (guidePageTexture.imageContent == null) {
                return MissingTextureAtlasSprite.getLocation();
            }
            try {
                NativeImage nativeImage = NativeImage.read((ByteBuffer)guidePageTexture.imageContent);
                ResourceLocation textureId = GuideME.makeId((String)("guidepage/" + this.id.getNamespace() + "/" + this.id.getPath()));
                DynamicTexture texture = new DynamicTexture(() -> ((ResourceLocation)textureId).toString(), nativeImage);
                Minecraft.getInstance().getTextureManager().register(textureId, (AbstractTexture)texture);
                return textureId;
            }
            catch (IOException e) {
                LOG.error("Failed to read image {}: {}", (Object)guidePageTexture.id, (Object)e.toString());
                return MissingTextureAtlasSprite.getLocation();
            }
        });
    }

    public static void releaseUsedTextures() {
        for (ResourceLocation textureId : usedTextures.values()) {
            if (textureId.equals((Object)MissingTextureAtlasSprite.getLocation())) continue;
            Minecraft.getInstance().getTextureManager().release(textureId);
        }
        usedTextures.clear();
    }
}

