/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.document.DefaultStyles;
import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.block.LytDocument;
import guideme.document.block.LytNode;
import guideme.document.block.LytParagraph;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LytPlaceholderBlock
extends LytBlock {
    private static final Logger LOG = LoggerFactory.getLogger(LytPlaceholderBlock.class);
    private final CompletableFuture<LytBlock> future;
    private LytBlock currentBlock;
    private final List<LytBlock> currentChildren = new ArrayList<LytBlock>(1);
    private final List<LytBlock> unmodifiableChildren = Collections.unmodifiableList(this.currentChildren);

    public LytPlaceholderBlock(CompletableFuture<LytBlock> future) {
        LytParagraph loading = new LytParagraph();
        loading.appendText("Loading...");
        this.setCurrent(loading);
        this.future = future;
        future.whenCompleteAsync(this::onLoad, (Executor)Minecraft.getInstance());
    }

    private void setCurrent(LytBlock block) {
        if (this.currentBlock != block) {
            this.currentChildren.clear();
            this.currentBlock = block;
            this.currentChildren.add(block);
            LytDocument document = this.getDocument();
            if (document != null) {
                document.invalidateLayout();
            }
        }
    }

    private void onLoad(LytBlock element, Throwable error) {
        if (error != null || element == null) {
            LOG.error("Failed to load an asynchronous guide element.", error);
            LytParagraph errorParagraph = new LytParagraph();
            errorParagraph.setStyle(DefaultStyles.ERROR_TEXT);
            if (error == null) {
                errorParagraph.appendText("An unknown error occurred");
            } else {
                errorParagraph.appendText(error.toString());
            }
            this.setCurrent(errorParagraph);
        } else {
            this.setCurrent(element);
        }
    }

    @Override
    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        return this.currentBlock.layout(context, x, y, availableWidth);
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
        this.currentBlock.onLayoutMoved(deltaX, deltaY);
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
        this.currentBlock.renderBatch(context, buffers);
    }

    @Override
    public void render(RenderContext context) {
        this.currentBlock.render(context);
    }

    @Override
    public List<? extends LytNode> getChildren() {
        return this.unmodifiableChildren;
    }
}

