/*
 * Decompiled with CFR 0.152.
 */
package guideme.render;

import guideme.color.LightDarkMode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuiSprite {
    private static final Logger LOG = LoggerFactory.getLogger(GuiSprite.class);
    private final ResourceLocation id;
    private volatile CachedState cachedState;

    public GuiSprite(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation get(LightDarkMode mode) {
        CachedState state = this.getOrCreateCachedState();
        return mode == LightDarkMode.DARK_MODE ? state.darkId : this.id;
    }

    public GuiSpriteScaling spriteScaling() {
        CachedState state = this.getOrCreateCachedState();
        return state.spriteScaling;
    }

    public TextureAtlasSprite atlasSprite(LightDarkMode mode) {
        CachedState state = this.getOrCreateCachedState();
        return mode == LightDarkMode.LIGHT_MODE ? state.sprite : state.darkSprite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedState getOrCreateCachedState() {
        CachedState result = this.cachedState;
        if (result != null) {
            return result;
        }
        GuiSprite guiSprite = this;
        synchronized (guiSprite) {
            GuiSpriteManager guiSprites = Minecraft.getInstance().getGuiSprites();
            TextureAtlasSprite sprite = guiSprites.getSprite(this.id);
            GuiSpriteScaling spriteScaling = guiSprites.getSpriteScaling(sprite);
            ResourceLocation darkId = this.id.withSuffix("_darkmode");
            TextureAtlasSprite darkSprite = guiSprites.getSprite(darkId);
            if (sprite.contents().name().equals((Object)MissingTextureAtlasSprite.getLocation())) {
                darkId = this.id;
                darkSprite = sprite;
            } else {
                GuiSpriteScaling darkScaling = guiSprites.getSpriteScaling(darkSprite);
                if (!darkScaling.equals((Object)spriteScaling)) {
                    LOG.warn("Dark-mode sprite {} uses different sprite-scaling from the light-mode version. Please ensure the same .mcmeta file content is used.", (Object)darkId);
                }
            }
            this.cachedState = new CachedState(sprite, darkId, darkSprite, spriteScaling);
            return this.cachedState;
        }
    }

    void reset() {
        this.cachedState = null;
    }

    public String toString() {
        return this.id.toString();
    }

    private static final class CachedState
    extends Record {
        private final TextureAtlasSprite sprite;
        private final ResourceLocation darkId;
        private final TextureAtlasSprite darkSprite;
        private final GuiSpriteScaling spriteScaling;

        private CachedState(TextureAtlasSprite sprite, ResourceLocation darkId, TextureAtlasSprite darkSprite, GuiSpriteScaling spriteScaling) {
            this.sprite = sprite;
            this.darkId = darkId;
            this.darkSprite = darkSprite;
            this.spriteScaling = spriteScaling;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedState.class, "sprite;darkId;darkSprite;spriteScaling", "sprite", "darkId", "darkSprite", "spriteScaling"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedState.class, "sprite;darkId;darkSprite;spriteScaling", "sprite", "darkId", "darkSprite", "spriteScaling"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedState.class, "sprite;darkId;darkSprite;spriteScaling", "sprite", "darkId", "darkSprite", "spriteScaling"}, this, o);
        }
    }
}

