/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.factory;

import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Tokenizer;

public final class FactorySpace {
    public static State create(Tokenizer.Effects effects, State ok, String type) {
        return FactorySpace.create(effects, ok, type, null);
    }

    public static State create(Tokenizer.Effects effects, State ok, String type, Integer max) {
        int limit = max != null ? max - 1 : Integer.MAX_VALUE;
        return new StateMachine(effects, ok, type, limit)::start;
    }

    private static class StateMachine {
        private final Tokenizer.Effects effects;
        private final State ok;
        private final String type;
        private final int limit;
        private int size;

        public StateMachine(Tokenizer.Effects effects, State ok, String type, int limit) {
            this.effects = effects;
            this.ok = ok;
            this.type = type;
            this.limit = limit;
        }

        private State prefix(int code) {
            if (CharUtil.markdownSpace(code) && this.size++ < this.limit) {
                this.effects.consume(code);
                return this::prefix;
            }
            this.effects.exit(this.type);
            return this.ok.step(code);
        }

        public State start(int code) {
            if (CharUtil.markdownSpace(code)) {
                this.effects.enter(this.type);
                return this.prefix(code);
            }
            return this.ok.step(code);
        }
    }
}

