/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.util;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import guideme.compiler.FrontmatterNavigation;
import guideme.compiler.ParsedGuidePage;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NavigationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NavigationUtil.class);

    private NavigationUtil() {
    }

    public static ItemStack createNavigationIcon(ParsedGuidePage page) {
        FrontmatterNavigation navigation = page.getFrontmatter().navigationEntry();
        ItemStack icon = ItemStack.EMPTY;
        if (navigation != null && navigation.iconItemId() != null) {
            Holder.Reference iconItem = BuiltInRegistries.ITEM.get(navigation.iconItemId()).orElse(null);
            if (iconItem != null) {
                if (navigation.iconComponents() != null) {
                    Optional patch = DataComponentPatch.CODEC.parse((DynamicOps)JavaOps.INSTANCE, navigation.iconComponents()).resultOrPartial(err -> LOG.error("Failed to deserialize component patch {} for icon {}: {}", new Object[]{navigation.iconComponents(), navigation.iconItemId(), err}));
                    icon = new ItemStack((Holder)iconItem, 1, patch.orElse(DataComponentPatch.EMPTY));
                } else {
                    icon = new ItemStack((Holder)iconItem);
                }
            }
            if (icon.isEmpty()) {
                LOG.error("Couldn't find icon {} for icon of page {}", (Object)navigation.iconItemId(), (Object)page);
            }
        }
        return icon;
    }
}

