/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.siteexport;

import guideme.internal.GuideOnStartup;
import guideme.internal.GuideRegistry;
import guideme.internal.MutableGuide;
import guideme.internal.siteexport.SiteExporter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SiteExportOnStartup {
    private static final Logger LOG = LoggerFactory.getLogger(SiteExportOnStartup.class);

    private SiteExportOnStartup() {
    }

    public static void init() {
        Map<ResourceLocation, Path> guidesToExport = SiteExportOnStartup.getGuidesToExport();
        if (!guidesToExport.isEmpty()) {
            MutableBoolean guideExportRan = new MutableBoolean(false);
            NeoForge.EVENT_BUS.addListener(e -> {
                if (!guideExportRan.booleanValue()) {
                    guideExportRan.setTrue();
                    GuideOnStartup.runDatapackReload();
                    for (Map.Entry entry : guidesToExport.entrySet()) {
                        MutableGuide guide = GuideRegistry.getById((ResourceLocation)entry.getKey());
                        if (guide == null) {
                            LOG.error("Cannot validate guide '{}' since it does not exist.", entry.getKey());
                            System.exit(1);
                        }
                        Path outputFolder = (Path)entry.getValue();
                        try {
                            new SiteExporter(Minecraft.getInstance(), outputFolder, guide).export();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            System.exit(1);
                        }
                    }
                    Minecraft.getInstance().stop();
                }
            });
        }
    }

    private static Map<ResourceLocation, Path> getGuidesToExport() {
        String guideIdsString = System.getProperty("guideme.exportOnStartupAndExit");
        if (guideIdsString == null) {
            return Map.of();
        }
        HashMap<ResourceLocation, Path> guidesToExport = new HashMap<ResourceLocation, Path>();
        for (String unparsedResourceId : guideIdsString.split(",")) {
            ResourceLocation guideId = ResourceLocation.parse((String)unparsedResourceId);
            String destinationPropertyName = "guideme.exportDestination." + guideId.getNamespace() + "." + guideId.getPath();
            String destinationDirectory = System.getProperty(destinationPropertyName);
            if (destinationDirectory == null) {
                throw new RuntimeException("When exporting GuideME guide " + String.valueOf(guideId) + " also set a destination directory using system property " + destinationPropertyName);
            }
            guidesToExport.put(guideId, Paths.get(destinationDirectory, new String[0]));
        }
        return guidesToExport;
    }
}

