/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.methvin.watchservice;

import com.sun.jna.Pointer;
import guideme.internal.shaded.methvin.watcher.PathUtils;
import guideme.internal.shaded.methvin.watcher.hashing.FileHash;
import guideme.internal.shaded.methvin.watcher.hashing.FileHasher;
import guideme.internal.shaded.methvin.watcher.visitor.FileTreeVisitor;
import guideme.internal.shaded.methvin.watchservice.AbstractWatchKey;
import guideme.internal.shaded.methvin.watchservice.AbstractWatchService;
import guideme.internal.shaded.methvin.watchservice.MacOSXWatchKey;
import guideme.internal.shaded.methvin.watchservice.WatchablePath;
import guideme.internal.shaded.methvin.watchservice.jna.CFArrayRef;
import guideme.internal.shaded.methvin.watchservice.jna.CFIndex;
import guideme.internal.shaded.methvin.watchservice.jna.CFRunLoopRef;
import guideme.internal.shaded.methvin.watchservice.jna.CFStringRef;
import guideme.internal.shaded.methvin.watchservice.jna.CarbonAPI;
import guideme.internal.shaded.methvin.watchservice.jna.FSEventStreamRef;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicLong;

public class MacOSXListeningWatchService
extends AbstractWatchService {
    private FileHasher INCREMENTING_FILE_HASHER = new FileHasher(){
        private final AtomicLong value = new AtomicLong();

        @Override
        public FileHash hash(Path path) throws IOException {
            return FileHash.fromLong(this.value.incrementAndGet());
        }
    };
    private final List<CarbonAPI.FSEventStreamCallback> callbackList = new ArrayList<CarbonAPI.FSEventStreamCallback>();
    private final List<CFRunLoopThread> threadList = new ArrayList<CFRunLoopThread>();
    private final Set<Path> pathsWatching = new HashSet<Path>();
    private final double latency;
    private final int queueSize;
    private final FileHasher fileHasher;
    private final FileTreeVisitor fileTreeVisitor;
    private final boolean fileLevelEvents;
    private final long kFSEventStreamEventIdSinceNow = -1L;
    private final int kFSEventStreamCreateFlagNoDefer = 2;
    private final int kFSEventStreamCreateFlagFileEvents = 16;

    public MacOSXListeningWatchService(Config config) {
        this.latency = config.latency();
        this.queueSize = config.queueSize();
        this.fileTreeVisitor = config.fileTreeVisitor();
        FileHasher fileHasher = config.fileHasher();
        this.fileLevelEvents = fileHasher == null || config.fileLevelEvents();
        this.fileHasher = fileHasher == null ? this.INCREMENTING_FILE_HASHER : fileHasher;
    }

    public MacOSXListeningWatchService() {
        this(new Config(){});
    }

    @Override
    public synchronized AbstractWatchKey register(WatchablePath watchablePath, Iterable<? extends WatchEvent.Kind<?>> iterable) throws IOException {
        this.checkOpen();
        MacOSXWatchKey macOSXWatchKey = new MacOSXWatchKey((AbstractWatchService)this, watchablePath, iterable, this.queueSize);
        Path path = watchablePath.getFile().toAbsolutePath();
        for (Path pointerArray2 : this.pathsWatching) {
            if (!path.startsWith(pointerArray2)) continue;
            return macOSXWatchKey;
        }
        SortedMap<Path, FileHash> sortedMap = PathUtils.createHashCodeMap(path, this.fileHasher, this.fileTreeVisitor);
        Pointer[] pointerArray = new Pointer[]{CFStringRef.toCFString(path.toString()).getPointer()};
        CFArrayRef cFArrayRef = CarbonAPI.INSTANCE.CFArrayCreate(null, pointerArray, CFIndex.valueOf(1), null);
        MacOSXListeningCallback macOSXListeningCallback = new MacOSXListeningCallback(macOSXWatchKey, this.fileHasher, this.fileTreeVisitor, sortedMap, path);
        this.callbackList.add(macOSXListeningCallback);
        int n = 2;
        if (this.fileLevelEvents) {
            n |= 0x10;
        }
        FSEventStreamRef fSEventStreamRef = CarbonAPI.INSTANCE.FSEventStreamCreate(Pointer.NULL, macOSXListeningCallback, Pointer.NULL, cFArrayRef, -1L, this.latency, n);
        CFRunLoopThread cFRunLoopThread = new CFRunLoopThread(fSEventStreamRef, path.toFile());
        macOSXListeningCallback.onClose(() -> this.close(cFRunLoopThread, macOSXListeningCallback, path));
        cFRunLoopThread.setDaemon(true);
        cFRunLoopThread.start();
        this.threadList.add(cFRunLoopThread);
        this.pathsWatching.add(path);
        return macOSXWatchKey;
    }

    @Override
    public synchronized void close() {
        super.close();
        this.threadList.forEach(CFRunLoopThread::close);
        this.threadList.clear();
        this.callbackList.clear();
        this.pathsWatching.clear();
    }

    public synchronized void close(CFRunLoopThread cFRunLoopThread, CarbonAPI.FSEventStreamCallback fSEventStreamCallback, Path path) {
        this.threadList.remove(cFRunLoopThread);
        this.callbackList.remove(fSEventStreamCallback);
        this.pathsWatching.remove(path);
        cFRunLoopThread.close();
    }

    private static class MacOSXListeningCallback
    implements CarbonAPI.FSEventStreamCallback {
        private final MacOSXWatchKey watchKey;
        private final SortedMap<Path, FileHash> hashCodeMap;
        private final FileHasher fileHasher;
        private final FileTreeVisitor fileTreeVisitor;
        private final Path realPath;
        private final Path absPath;
        private final int realPathSize;
        private Runnable onCloseCallback;

        private MacOSXListeningCallback(MacOSXWatchKey macOSXWatchKey, FileHasher fileHasher, FileTreeVisitor fileTreeVisitor, SortedMap<Path, FileHash> sortedMap, Path path) throws IOException {
            this.watchKey = macOSXWatchKey;
            this.hashCodeMap = sortedMap;
            this.fileHasher = fileHasher;
            this.fileTreeVisitor = fileTreeVisitor;
            this.realPath = path.toRealPath(new LinkOption[0]);
            this.absPath = path;
            this.realPathSize = this.realPath.toString().length() + 1;
        }

        public void onClose(Runnable runnable) {
            this.onCloseCallback = runnable;
        }
    }

    public static class CFRunLoopThread
    extends Thread {
        private final FSEventStreamRef streamRef;
        private CFRunLoopRef runLoopRef;
        private boolean isClosed = false;

        public CFRunLoopThread(FSEventStreamRef fSEventStreamRef, File file) {
            super("WatchService for " + file);
            this.streamRef = fSEventStreamRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FSEventStreamRef fSEventStreamRef = this.streamRef;
            synchronized (fSEventStreamRef) {
                if (this.isClosed) {
                    return;
                }
                this.runLoopRef = CarbonAPI.INSTANCE.CFRunLoopGetCurrent();
                CFStringRef cFStringRef = CFStringRef.toCFString("kCFRunLoopDefaultMode");
                CarbonAPI.INSTANCE.FSEventStreamScheduleWithRunLoop(this.streamRef, this.runLoopRef, cFStringRef);
                CarbonAPI.INSTANCE.FSEventStreamStart(this.streamRef);
            }
            CarbonAPI.INSTANCE.CFRunLoopRun();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            FSEventStreamRef fSEventStreamRef = this.streamRef;
            synchronized (fSEventStreamRef) {
                if (this.isClosed) {
                    return;
                }
                if (this.runLoopRef != null) {
                    CarbonAPI.INSTANCE.CFRunLoopStop(this.runLoopRef);
                    CarbonAPI.INSTANCE.FSEventStreamStop(this.streamRef);
                    CarbonAPI.INSTANCE.FSEventStreamInvalidate(this.streamRef);
                }
                CarbonAPI.INSTANCE.FSEventStreamRelease(this.streamRef);
                this.isClosed = true;
            }
        }
    }

    public static interface Config {
        default public double latency() {
            return 0.5;
        }

        default public int queueSize() {
            return 1024;
        }

        default public boolean fileLevelEvents() {
            return false;
        }

        default public FileHasher fileHasher() {
            return FileHasher.DEFAULT_FILE_HASHER;
        }

        default public FileTreeVisitor fileTreeVisitor() {
            return FileTreeVisitor.DEFAULT_FILE_TREE_VISITOR;
        }
    }
}

