/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.hnsw;

import guideme.internal.shaded.lucene.search.KnnCollector;
import guideme.internal.shaded.lucene.util.BitSet;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.FixedBitSet;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraph;
import guideme.internal.shaded.lucene.util.hnsw.NeighborQueue;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorer;
import java.io.IOException;

public class HnswGraphSearcher {
    private final NeighborQueue candidates;
    private BitSet visited;

    public HnswGraphSearcher(NeighborQueue candidates, BitSet visited) {
        this.candidates = candidates;
        this.visited = visited;
    }

    void searchLevel(KnnCollector results, RandomVectorScorer scorer, int level, int[] eps, HnswGraph graph, Bits acceptOrds) throws IOException {
        float topCandidateSimilarity;
        int size = HnswGraphSearcher.getGraphSize(graph);
        this.prepareScratchState(size);
        for (int ep : eps) {
            if (this.visited.getAndSet(ep)) continue;
            if (results.earlyTerminated()) break;
            float score = scorer.score(ep);
            results.incVisitedCount(1);
            this.candidates.add(ep, score);
            if (acceptOrds != null && !acceptOrds.get(ep)) continue;
            results.collect(ep, score);
        }
        float minAcceptedSimilarity = results.minCompetitiveSimilarity();
        block1: while (this.candidates.size() > 0 && !results.earlyTerminated() && !((topCandidateSimilarity = this.candidates.topScore()) < minAcceptedSimilarity)) {
            int friendOrd;
            int topCandidateNode = this.candidates.pop();
            this.graphSeek(graph, level, topCandidateNode);
            while ((friendOrd = this.graphNextNeighbor(graph)) != Integer.MAX_VALUE) {
                assert (friendOrd < size) : "friendOrd=" + friendOrd + "; size=" + size;
                if (this.visited.getAndSet(friendOrd)) continue;
                if (results.earlyTerminated()) continue block1;
                float friendSimilarity = scorer.score(friendOrd);
                results.incVisitedCount(1);
                if (!(friendSimilarity > minAcceptedSimilarity)) continue;
                this.candidates.add(friendOrd, friendSimilarity);
                if (acceptOrds != null && !acceptOrds.get(friendOrd) || !results.collect(friendOrd, friendSimilarity)) continue;
                minAcceptedSimilarity = results.minCompetitiveSimilarity();
            }
        }
    }

    private void prepareScratchState(int capacity) {
        this.candidates.clear();
        if (this.visited.length() < capacity) {
            this.visited = FixedBitSet.ensureCapacity((FixedBitSet)this.visited, capacity);
        }
        this.visited.clear();
    }

    void graphSeek(HnswGraph graph, int level, int targetNode) throws IOException {
        graph.seek(level, targetNode);
    }

    int graphNextNeighbor(HnswGraph graph) throws IOException {
        return graph.nextNeighbor();
    }

    private static int getGraphSize(HnswGraph graph) {
        return graph.maxNodeId() + 1;
    }
}

