/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.automaton;

import guideme.internal.shaded.lucene.util.UnicodeUtil;
import guideme.internal.shaded.lucene.util.automaton.Automata;
import guideme.internal.shaded.lucene.util.automaton.Automaton;
import guideme.internal.shaded.lucene.util.automaton.Operations;

public class LevenshteinAutomata {
    final int[] word;
    final int[] alphabet;
    final int[] rangeLower;
    final int[] rangeUpper;
    int numRanges;
    ParametricDescription[] descriptions;

    public Automaton toAutomaton(int n, String prefix) {
        int state;
        int lastState;
        assert (prefix != null);
        if (n == 0) {
            return Automata.makeString(prefix + UnicodeUtil.newString(this.word, 0, this.word.length));
        }
        if (n >= this.descriptions.length) {
            return null;
        }
        int range = 2 * n + 1;
        ParametricDescription description = this.descriptions[n];
        int numStates = description.size();
        int numTransitions = numStates * Math.min(1 + 2 * n, this.alphabet.length);
        int prefixStates = prefix != null ? prefix.codePointCount(0, prefix.length()) : 0;
        Automaton a = new Automaton(numStates + prefixStates, numTransitions);
        if (prefix != null) {
            lastState = a.createState();
            int cp = 0;
            for (int i = 0; i < prefix.length(); i += Character.charCount(cp)) {
                state = a.createState();
                cp = prefix.codePointAt(i);
                a.addTransition(lastState, state, cp, cp);
                lastState = state;
            }
        } else {
            lastState = a.createState();
        }
        int stateOffset = lastState;
        a.setAccept(lastState, description.isAccept(0));
        for (int i = 1; i < numStates; ++i) {
            state = a.createState();
            a.setAccept(state, description.isAccept(i));
        }
        for (int k = 0; k < numStates; ++k) {
            int xpos = description.getPosition(k);
            if (xpos < 0) continue;
            int end = xpos + Math.min(this.word.length - xpos, range);
            for (int x = 0; x < this.alphabet.length; ++x) {
                int ch = this.alphabet[x];
                int cvec = this.getVector(ch, xpos, end);
                int dest = description.transition(k, xpos, cvec);
                if (dest < 0) continue;
                a.addTransition(stateOffset + k, stateOffset + dest, ch);
            }
            int dest = description.transition(k, xpos, 0);
            if (dest < 0) continue;
            for (int r = 0; r < this.numRanges; ++r) {
                a.addTransition(stateOffset + k, stateOffset + dest, this.rangeLower[r], this.rangeUpper[r]);
            }
        }
        a.finishState();
        Automaton automaton = Operations.removeDeadStates(a);
        assert (automaton.isDeterministic());
        return automaton;
    }

    int getVector(int x, int pos, int end) {
        int vector = 0;
        for (int i = pos; i < end; ++i) {
            vector <<= 1;
            if (this.word[i] != x) continue;
            vector |= 1;
        }
        return vector;
    }

    static abstract class ParametricDescription {
        protected final int w;
        protected final int n;
        private final int[] minErrors;
        private static final long[] MASKS = new long[]{1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE};

        int size() {
            return this.minErrors.length * (this.w + 1);
        }

        boolean isAccept(int absState) {
            int state = absState / (this.w + 1);
            int offset = absState % (this.w + 1);
            assert (offset >= 0);
            return this.w - offset + this.minErrors[state] <= this.n;
        }

        int getPosition(int absState) {
            return absState % (this.w + 1);
        }

        abstract int transition(int var1, int var2, int var3);
    }
}

