/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

public final class NumericUtils {
    private NumericUtils() {
    }

    public static long doubleToSortableLong(double value) {
        return NumericUtils.sortableDoubleBits(Double.doubleToLongBits(value));
    }

    public static int floatToSortableInt(float value) {
        return NumericUtils.sortableFloatBits(Float.floatToIntBits(value));
    }

    public static float sortableIntToFloat(int encoded) {
        return Float.intBitsToFloat(NumericUtils.sortableFloatBits(encoded));
    }

    public static long sortableDoubleBits(long bits) {
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }

    public static int sortableFloatBits(int bits) {
        return bits ^ bits >> 31 & Integer.MAX_VALUE;
    }

    public static void subtract(int bytesPerDim, int dim, byte[] a, byte[] b, byte[] result) {
        int start = dim * bytesPerDim;
        int end = start + bytesPerDim;
        int borrow = 0;
        for (int i = end - 1; i >= start; --i) {
            int diff = (a[i] & 0xFF) - (b[i] & 0xFF) - borrow;
            if (diff < 0) {
                diff += 256;
                borrow = 1;
            } else {
                borrow = 0;
            }
            result[i - start] = (byte)diff;
        }
        if (borrow != 0) {
            throw new IllegalArgumentException("a < b");
        }
    }
}

