/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.store.RandomAccessInput;
import guideme.internal.shaded.lucene.store.ReadAdvice;
import java.io.Closeable;
import java.io.IOException;

public abstract class IndexInput
extends DataInput
implements Closeable {
    private final String resourceDescription;

    protected IndexInput(String resourceDescription) {
        if (resourceDescription == null) {
            throw new IllegalArgumentException("resourceDescription must not be null");
        }
        this.resourceDescription = resourceDescription;
    }

    @Override
    public abstract void close() throws IOException;

    public abstract long getFilePointer();

    public abstract void seek(long var1) throws IOException;

    @Override
    public void skipBytes(long numBytes) throws IOException {
        if (numBytes < 0L) {
            throw new IllegalArgumentException("numBytes must be >= 0, got " + numBytes);
        }
        long skipTo = this.getFilePointer() + numBytes;
        this.seek(skipTo);
    }

    public abstract long length();

    public String toString() {
        return this.resourceDescription;
    }

    @Override
    public IndexInput clone() {
        return (IndexInput)super.clone();
    }

    public abstract IndexInput slice(String var1, long var2, long var4) throws IOException;

    public IndexInput slice(String sliceDescription, long offset, long length, ReadAdvice readAdvice) throws IOException {
        return this.slice(sliceDescription, offset, length);
    }

    public RandomAccessInput randomAccessSlice(long offset, final long length) throws IOException {
        final IndexInput slice = this.slice("randomaccess", offset, length);
        if (slice instanceof RandomAccessInput) {
            return (RandomAccessInput)((Object)slice);
        }
        return new RandomAccessInput(){

            @Override
            public long length() {
                assert (length == slice.length());
                return slice.length();
            }

            @Override
            public byte readByte(long pos) throws IOException {
                slice.seek(pos);
                return slice.readByte();
            }

            @Override
            public void readBytes(long pos, byte[] bytes, int offset, int length2) throws IOException {
                slice.seek(pos);
                slice.readBytes(bytes, offset, length2);
            }

            @Override
            public short readShort(long pos) throws IOException {
                slice.seek(pos);
                return slice.readShort();
            }

            @Override
            public int readInt(long pos) throws IOException {
                slice.seek(pos);
                return slice.readInt();
            }

            @Override
            public long readLong(long pos) throws IOException {
                slice.seek(pos);
                return slice.readLong();
            }

            @Override
            public void prefetch(long offset, long length2) throws IOException {
                slice.prefetch(offset, length2);
            }

            public String toString() {
                return "RandomAccessInput(" + IndexInput.this.toString() + ")";
            }
        };
    }

    public void prefetch(long offset, long length) throws IOException {
    }

    public void updateReadAdvice(ReadAdvice readAdvice) throws IOException {
    }
}

