/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.FuzzyTermsEnum;
import guideme.internal.shaded.lucene.util.automaton.CompiledAutomaton;
import guideme.internal.shaded.lucene.util.automaton.LevenshteinAutomata;
import guideme.internal.shaded.lucene.util.automaton.TooComplexToDeterminizeException;

class FuzzyAutomatonBuilder {
    private final String term;
    private final int maxEdits;
    private final LevenshteinAutomata levBuilder;
    private final String prefix;
    private final int termLength;

    CompiledAutomaton[] buildAutomatonSet() {
        CompiledAutomaton[] compiled = new CompiledAutomaton[this.maxEdits + 1];
        for (int i = 0; i <= this.maxEdits; ++i) {
            try {
                compiled[i] = new CompiledAutomaton(this.levBuilder.toAutomaton(i, this.prefix), true, false);
                continue;
            }
            catch (TooComplexToDeterminizeException e) {
                throw new FuzzyTermsEnum.FuzzyTermsException(this.term, e);
            }
        }
        return compiled;
    }

    int getTermLength() {
        return this.termLength;
    }
}

