/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanQuery;
import guideme.internal.shaded.lucene.search.BooleanScorerSupplier;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;

final class BooleanWeight
extends Weight {
    final Similarity similarity;
    final BooleanQuery query;
    final ArrayList<WeightedBooleanClause> weightedClauses;
    final ScoreMode scoreMode;

    BooleanWeight(BooleanQuery query, IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        super(query);
        this.query = query;
        this.scoreMode = scoreMode;
        this.similarity = searcher.getSimilarity();
        this.weightedClauses = new ArrayList();
        for (BooleanClause c : query) {
            Weight w = searcher.createWeight(c.query(), c.isScoring() ? scoreMode : ScoreMode.COMPLETE_NO_SCORES, boost);
            this.weightedClauses.add(new WeightedBooleanClause(c, w));
        }
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        if (this.query.clauses().size() > 16) {
            return false;
        }
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            if (w.isCacheable(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>> scorers = new EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>>(BooleanClause.Occur.class);
        for (BooleanClause.Occur occur : BooleanClause.Occur.values()) {
            scorers.put(occur, new ArrayList());
        }
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            BooleanClause c = wc.clause;
            ScorerSupplier subScorer = w.scorerSupplier(context);
            if (subScorer == null) {
                if (!c.isRequired()) continue;
                return null;
            }
            ((Collection)scorers.get((Object)c.occur())).add(subScorer);
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() == minShouldMatch) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).addAll((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD));
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
            minShouldMatch = 0;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).isEmpty()) {
            return null;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() < minShouldMatch) {
            return null;
        }
        if (!this.scoreMode.needsScores() && minShouldMatch == 0 && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).size() + ((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).size() > 0) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
        }
        return new BooleanScorerSupplier(this, scorers, this.scoreMode, minShouldMatch, context.reader().maxDoc());
    }

    protected static class WeightedBooleanClause {
        final BooleanClause clause;
        final Weight weight;

        WeightedBooleanClause(BooleanClause clause, Weight weight) {
            this.clause = clause;
            this.weight = weight;
        }
    }
}

