/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.internal.hppc;

import guideme.internal.shaded.lucene.internal.hppc.AbstractIterator;
import guideme.internal.shaded.lucene.internal.hppc.BitMixer;
import guideme.internal.shaded.lucene.internal.hppc.IntCursor;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.util.Arrays;
import java.util.Iterator;

public class IntArrayList
implements Accountable,
Cloneable,
Iterable<IntCursor> {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntArrayList.class);
    public static final int[] EMPTY_ARRAY = new int[0];
    public int[] buffer;
    public int elementsCount;

    public IntArrayList() {
        this(4);
    }

    public IntArrayList(int expectedElements) {
        this.buffer = new int[expectedElements];
    }

    public void add(int e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public int get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [0, " + this.size() + ").";
        return this.buffer[index];
    }

    public int removeLast() {
        assert (!this.isEmpty()) : "List is empty";
        return this.buffer[--this.elementsCount];
    }

    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        if (this.elementsCount + expectedAdditions > this.buffer.length) {
            this.buffer = ArrayUtil.grow(this.buffer, this.elementsCount + expectedAdditions);
        }
    }

    public int size() {
        return this.elementsCount;
    }

    public int[] toArray() {
        return ArrayUtil.copyOfSubArray(this.buffer, 0, this.elementsCount);
    }

    public IntArrayList clone() {
        try {
            IntArrayList cloned = (IntArrayList)super.clone();
            cloned.buffer = (int[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((IntArrayList)this.getClass().cast(obj));
    }

    protected boolean equalElements(IntArrayList other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.buffer);
    }

    public IntArrayList reverse() {
        int i = 0;
        int mid = this.elementsCount >> 1;
        int j = this.elementsCount - 1;
        while (i < mid) {
            int tmp = this.buffer[i];
            this.buffer[i] = this.buffer[j];
            this.buffer[j] = tmp;
            ++i;
            --j;
        }
        return this;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    static final class ValueIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private final int[] buffer;
        private final int size;

        public ValueIterator(int[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected IntCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (IntCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

