/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.DocValuesProducer;
import guideme.internal.shaded.lucene.codecs.FieldsProducer;
import guideme.internal.shaded.lucene.codecs.KnnVectorsReader;
import guideme.internal.shaded.lucene.codecs.NormsProducer;
import guideme.internal.shaded.lucene.codecs.PointsReader;
import guideme.internal.shaded.lucene.codecs.StoredFieldsReader;
import guideme.internal.shaded.lucene.codecs.TermVectorsReader;
import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.CodecReader;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.DocValuesSkipper;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.Fields;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.KnnVectorValues;
import guideme.internal.shaded.lucene.index.LeafMetaData;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.MultiBits;
import guideme.internal.shaded.lucene.index.MultiDocValues;
import guideme.internal.shaded.lucene.index.MultiFields;
import guideme.internal.shaded.lucene.index.MultiReader;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.OrdinalMap;
import guideme.internal.shaded.lucene.index.PointValues;
import guideme.internal.shaded.lucene.index.ReaderSlice;
import guideme.internal.shaded.lucene.index.SortedDocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.index.SortedSetDocValues;
import guideme.internal.shaded.lucene.index.StoredFieldVisitor;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.IOUtils;
import guideme.internal.shaded.lucene.util.Version;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class SlowCompositeCodecReaderWrapper
extends CodecReader {
    private final LeafMetaData meta;
    private final CodecReader[] codecReaders;
    private final int[] docStarts;
    private final FieldInfos fieldInfos;
    private final Bits liveDocs;
    int numDocs = -1;

    static CodecReader wrap(List<CodecReader> readers) throws IOException {
        switch (readers.size()) {
            case 0: {
                throw new IllegalArgumentException("Must take at least one reader, got 0");
            }
            case 1: {
                return readers.get(0);
            }
        }
        return new SlowCompositeCodecReaderWrapper(readers);
    }

    private SlowCompositeCodecReaderWrapper(List<CodecReader> codecReaders) throws IOException {
        this.codecReaders = (CodecReader[])codecReaders.toArray(CodecReader[]::new);
        this.docStarts = new int[codecReaders.size() + 1];
        int i = 0;
        int docStart = 0;
        for (CodecReader reader : codecReaders) {
            this.docStarts[++i] = docStart += reader.maxDoc();
        }
        int majorVersion = -1;
        Version minVersion = null;
        boolean hasBlocks = false;
        for (CodecReader reader : codecReaders) {
            LeafMetaData readerMeta = reader.getMetaData();
            if (majorVersion == -1) {
                majorVersion = readerMeta.createdVersionMajor();
            } else if (majorVersion != readerMeta.createdVersionMajor()) {
                throw new IllegalArgumentException("Cannot combine leaf readers created with different major versions");
            }
            if (minVersion == null) {
                minVersion = readerMeta.minVersion();
            } else if (minVersion.onOrAfter(readerMeta.minVersion())) {
                minVersion = readerMeta.minVersion();
            }
            hasBlocks |= readerMeta.hasBlocks();
        }
        this.meta = new LeafMetaData(majorVersion, minVersion, null, hasBlocks);
        MultiReader multiReader = new MultiReader((IndexReader[])codecReaders.toArray(CodecReader[]::new));
        this.fieldInfos = FieldInfos.getMergedFieldInfos(multiReader);
        this.liveDocs = MultiBits.getLiveDocs(multiReader);
    }

    private int docIdToReaderId(int doc) {
        Objects.checkIndex(doc, this.docStarts[this.docStarts.length - 1]);
        int readerId = Arrays.binarySearch(this.docStarts, doc);
        if (readerId < 0) {
            readerId = -2 - readerId;
        }
        return readerId;
    }

    @Override
    public StoredFieldsReader getFieldsReader() {
        StoredFieldsReader[] readers = (StoredFieldsReader[])Arrays.stream(this.codecReaders).map(CodecReader::getFieldsReader).toArray(StoredFieldsReader[]::new);
        return new SlowCompositeStoredFieldsReaderWrapper(readers, this.docStarts);
    }

    private FieldInfo remap(FieldInfo info) {
        return this.fieldInfos.fieldInfo(info.name);
    }

    @Override
    public TermVectorsReader getTermVectorsReader() {
        TermVectorsReader[] readers = (TermVectorsReader[])Arrays.stream(this.codecReaders).map(CodecReader::getTermVectorsReader).toArray(TermVectorsReader[]::new);
        return new SlowCompositeTermVectorsReaderWrapper(readers, this.docStarts);
    }

    @Override
    public NormsProducer getNormsReader() {
        return new SlowCompositeNormsProducer(this.codecReaders);
    }

    @Override
    public DocValuesProducer getDocValuesReader() {
        return new SlowCompositeDocValuesProducerWrapper(this.codecReaders, this.docStarts);
    }

    @Override
    public FieldsProducer getPostingsReader() {
        FieldsProducer[] producers = (FieldsProducer[])Arrays.stream(this.codecReaders).map(CodecReader::getPostingsReader).toArray(FieldsProducer[]::new);
        return new SlowCompositeFieldsProducerWrapper(producers, this.docStarts);
    }

    @Override
    public PointsReader getPointsReader() {
        return new SlowCompositePointsReaderWrapper(this.codecReaders, this.docStarts);
    }

    @Override
    public KnnVectorsReader getVectorReader() {
        return new SlowCompositeKnnVectorsReaderWrapper(this.codecReaders, this.docStarts);
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public Bits getLiveDocs() {
        return this.liveDocs;
    }

    @Override
    public LeafMetaData getMetaData() {
        return this.meta;
    }

    @Override
    public synchronized int numDocs() {
        if (this.numDocs == -1) {
            this.numDocs = 0;
            for (CodecReader reader : this.codecReaders) {
                this.numDocs += reader.numDocs();
            }
        }
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.docStarts[this.docStarts.length - 1];
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    private class SlowCompositeStoredFieldsReaderWrapper
    extends StoredFieldsReader {
        private final StoredFieldsReader[] readers;
        private final int[] docStarts;

        SlowCompositeStoredFieldsReaderWrapper(StoredFieldsReader[] readers, int[] docStarts) {
            this.readers = readers;
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public StoredFieldsReader clone() {
            return new SlowCompositeStoredFieldsReaderWrapper((StoredFieldsReader[])Arrays.stream(this.readers).map(StoredFieldsReader::clone).toArray(StoredFieldsReader[]::new), this.docStarts);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (StoredFieldsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public void document(int docID, final StoredFieldVisitor visitor) throws IOException {
            int readerId = SlowCompositeCodecReaderWrapper.this.docIdToReaderId(docID);
            this.readers[readerId].document(docID - this.docStarts[readerId], new StoredFieldVisitor(){

                @Override
                public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                    return visitor.needsField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo));
                }

                @Override
                public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
                    visitor.binaryField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void stringField(FieldInfo fieldInfo, String value) throws IOException {
                    visitor.stringField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void intField(FieldInfo fieldInfo, int value) throws IOException {
                    visitor.intField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void longField(FieldInfo fieldInfo, long value) throws IOException {
                    visitor.longField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void floatField(FieldInfo fieldInfo, float value) throws IOException {
                    visitor.floatField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
                    visitor.doubleField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }
            });
        }
    }

    private class SlowCompositeTermVectorsReaderWrapper
    extends TermVectorsReader {
        private final TermVectorsReader[] readers;
        private final int[] docStarts;

        SlowCompositeTermVectorsReaderWrapper(TermVectorsReader[] readers, int[] docStarts) {
            this.readers = readers;
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public TermVectorsReader clone() {
            return new SlowCompositeTermVectorsReaderWrapper((TermVectorsReader[])Arrays.stream(this.readers).map(TermVectorsReader::clone).toArray(TermVectorsReader[]::new), this.docStarts);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (TermVectorsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public Fields get(int doc) throws IOException {
            int readerId = SlowCompositeCodecReaderWrapper.this.docIdToReaderId(doc);
            TermVectorsReader reader = this.readers[readerId];
            if (reader == null) {
                return null;
            }
            return reader.get(doc - this.docStarts[readerId]);
        }
    }

    private static class SlowCompositeNormsProducer
    extends NormsProducer {
        private final CodecReader[] codecReaders;
        private final NormsProducer[] producers;

        SlowCompositeNormsProducer(CodecReader[] codecReaders) {
            this.codecReaders = codecReaders;
            this.producers = (NormsProducer[])Arrays.stream(codecReaders).map(CodecReader::getNormsReader).toArray(NormsProducer[]::new);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.producers);
        }

        @Override
        public NumericDocValues getNorms(FieldInfo field) throws IOException {
            return MultiDocValues.getNormValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (NormsProducer producer : this.producers) {
                if (producer == null) continue;
                producer.checkIntegrity();
            }
        }
    }

    private static class SlowCompositeDocValuesProducerWrapper
    extends DocValuesProducer {
        private final CodecReader[] codecReaders;
        private final DocValuesProducer[] producers;
        private final int[] docStarts;
        private final Map<String, OrdinalMap> cachedOrdMaps = new HashMap<String, OrdinalMap>();

        SlowCompositeDocValuesProducerWrapper(CodecReader[] codecReaders, int[] docStarts) {
            this.codecReaders = codecReaders;
            this.producers = (DocValuesProducer[])Arrays.stream(codecReaders).map(CodecReader::getDocValuesReader).toArray(DocValuesProducer[]::new);
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.producers);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (DocValuesProducer producer : this.producers) {
                if (producer == null) continue;
                producer.checkIntegrity();
            }
        }

        @Override
        public NumericDocValues getNumeric(FieldInfo field) throws IOException {
            return MultiDocValues.getNumericValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
        }

        @Override
        public BinaryDocValues getBinary(FieldInfo field) throws IOException {
            return MultiDocValues.getBinaryValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedDocValues getSorted(FieldInfo field) throws IOException {
            OrdinalMap map = null;
            Map<String, OrdinalMap> map2 = this.cachedOrdMaps;
            synchronized (map2) {
                map = this.cachedOrdMaps.get(field.name);
                if (map == null) {
                    SortedDocValues dv = MultiDocValues.getSortedValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
                    if (dv instanceof MultiDocValues.MultiSortedDocValues) {
                        map = ((MultiDocValues.MultiSortedDocValues)dv).mapping;
                        this.cachedOrdMaps.put(field.name, map);
                    }
                    return dv;
                }
            }
            int size = this.codecReaders.length;
            SortedDocValues[] values = new SortedDocValues[size];
            long totalCost = 0L;
            for (int i = 0; i < size; ++i) {
                CodecReader reader = this.codecReaders[i];
                SortedDocValues v = ((LeafReader)reader).getSortedDocValues(field.name);
                if (v == null) {
                    v = DocValues.emptySorted();
                }
                values[i] = v;
                totalCost += v.cost();
            }
            return new MultiDocValues.MultiSortedDocValues(values, this.docStarts, map, totalCost);
        }

        @Override
        public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
            return MultiDocValues.getSortedNumericValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
            OrdinalMap map = null;
            Map<String, OrdinalMap> map2 = this.cachedOrdMaps;
            synchronized (map2) {
                map = this.cachedOrdMaps.get(field.name);
                if (map == null) {
                    SortedSetDocValues dv = MultiDocValues.getSortedSetValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
                    if (dv instanceof MultiDocValues.MultiSortedSetDocValues) {
                        map = ((MultiDocValues.MultiSortedSetDocValues)dv).mapping;
                        this.cachedOrdMaps.put(field.name, map);
                    }
                    return dv;
                }
            }
            assert (map != null);
            int size = this.codecReaders.length;
            SortedSetDocValues[] values = new SortedSetDocValues[size];
            long totalCost = 0L;
            for (int i = 0; i < size; ++i) {
                CodecReader reader = this.codecReaders[i];
                SortedSetDocValues v = ((LeafReader)reader).getSortedSetDocValues(field.name);
                if (v == null) {
                    v = DocValues.emptySortedSet();
                }
                values[i] = v;
                totalCost += v.cost();
            }
            return new MultiDocValues.MultiSortedSetDocValues(values, this.docStarts, map, totalCost);
        }

        @Override
        public DocValuesSkipper getSkipper(FieldInfo field) throws IOException {
            throw new UnsupportedOperationException("This method is for searching not for merging");
        }
    }

    private static class SlowCompositeFieldsProducerWrapper
    extends FieldsProducer {
        private final FieldsProducer[] producers;
        private final MultiFields fields;

        SlowCompositeFieldsProducerWrapper(FieldsProducer[] producers, int[] docStarts) {
            this.producers = producers;
            ArrayList<FieldsProducer> subs = new ArrayList<FieldsProducer>();
            ArrayList<ReaderSlice> slices = new ArrayList<ReaderSlice>();
            int i = 0;
            for (FieldsProducer producer : producers) {
                if (producer != null) {
                    subs.add(producer);
                    slices.add(new ReaderSlice(docStarts[i], docStarts[i + 1], i));
                }
                ++i;
            }
            this.fields = new MultiFields((Fields[])subs.toArray(Fields[]::new), (ReaderSlice[])slices.toArray(ReaderSlice[]::new));
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.producers);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (FieldsProducer producer : this.producers) {
                if (producer == null) continue;
                producer.checkIntegrity();
            }
        }

        @Override
        public Iterator<String> iterator() {
            return this.fields.iterator();
        }

        @Override
        public Terms terms(String field) throws IOException {
            return this.fields.terms(field);
        }

        @Override
        public int size() {
            return this.fields.size();
        }
    }

    private static class SlowCompositePointsReaderWrapper
    extends PointsReader {
        private final CodecReader[] codecReaders;
        private final PointsReader[] readers;
        private final int[] docStarts;

        SlowCompositePointsReaderWrapper(CodecReader[] codecReaders, int[] docStarts) {
            this.codecReaders = codecReaders;
            this.readers = (PointsReader[])Arrays.stream(codecReaders).map(CodecReader::getPointsReader).toArray(PointsReader[]::new);
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (PointsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public PointValues getValues(String field) throws IOException {
            final ArrayList<PointValuesSub> values = new ArrayList<PointValuesSub>();
            for (int i = 0; i < this.readers.length; ++i) {
                PointValues v;
                FieldInfo fi = this.codecReaders[i].getFieldInfos().fieldInfo(field);
                if (fi == null || fi.getPointDimensionCount() <= 0 || (v = this.readers[i].getValues(field)) == null) continue;
                values.add(new PointValuesSub(v, this.docStarts[i]));
            }
            if (values.isEmpty()) {
                return null;
            }
            return new PointValues(this){

                @Override
                public PointValues.PointTree getPointTree() throws IOException {
                    return new PointValues.PointTree(){

                        @Override
                        public PointValues.PointTree clone() {
                            return this;
                        }

                        @Override
                        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
                            for (PointValuesSub sub : values) {
                                sub.sub.getPointTree().visitDocValues(this.wrapIntersectVisitor(visitor, sub.docBase));
                            }
                        }

                        @Override
                        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
                            for (PointValuesSub sub : values) {
                                sub.sub.getPointTree().visitDocIDs(this.wrapIntersectVisitor(visitor, sub.docBase));
                            }
                        }

                        private PointValues.IntersectVisitor wrapIntersectVisitor(final PointValues.IntersectVisitor visitor, final int docStart) {
                            return new PointValues.IntersectVisitor(){

                                @Override
                                public void visit(int docID, byte[] packedValue) throws IOException {
                                    visitor.visit(docStart + docID, packedValue);
                                }

                                @Override
                                public void visit(int docID) throws IOException {
                                    visitor.visit(docStart + docID);
                                }

                                @Override
                                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                                    return visitor.compare(minPackedValue, maxPackedValue);
                                }
                            };
                        }

                        @Override
                        public long size() {
                            long size = 0L;
                            for (PointValuesSub sub : values) {
                                size += sub.sub.size();
                            }
                            return size;
                        }

                        @Override
                        public boolean moveToSibling() throws IOException {
                            return false;
                        }

                        @Override
                        public boolean moveToParent() throws IOException {
                            return false;
                        }

                        @Override
                        public boolean moveToChild() throws IOException {
                            return false;
                        }
                    };
                }

                @Override
                public int getNumDimensions() throws IOException {
                    return ((PointValuesSub)values.get((int)0)).sub.getNumDimensions();
                }

                @Override
                public int getNumIndexDimensions() throws IOException {
                    return ((PointValuesSub)values.get((int)0)).sub.getNumIndexDimensions();
                }

                @Override
                public int getBytesPerDimension() throws IOException {
                    return ((PointValuesSub)values.get((int)0)).sub.getBytesPerDimension();
                }

                @Override
                public long size() {
                    try {
                        return this.getPointTree().size();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                @Override
                public int getDocCount() {
                    int docCount = 0;
                    for (PointValuesSub sub : values) {
                        docCount += sub.sub.getDocCount();
                    }
                    return docCount;
                }
            };
        }
    }

    private static class SlowCompositeKnnVectorsReaderWrapper
    extends KnnVectorsReader {
        private final CodecReader[] codecReaders;
        private final KnnVectorsReader[] readers;
        private final int[] docStarts;

        SlowCompositeKnnVectorsReaderWrapper(CodecReader[] codecReaders, int[] docStarts) {
            this.codecReaders = codecReaders;
            this.readers = (KnnVectorsReader[])Arrays.stream(codecReaders).map(CodecReader::getVectorReader).toArray(KnnVectorsReader[]::new);
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (KnnVectorsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            ArrayList<DocValuesSub<FloatVectorValues>> subs = new ArrayList<DocValuesSub<FloatVectorValues>>();
            int i = 0;
            int dimension = -1;
            int size = 0;
            for (CodecReader reader : this.codecReaders) {
                FloatVectorValues values = reader.getFloatVectorValues(field);
                subs.add(new DocValuesSub<FloatVectorValues>(values, this.docStarts[i], size));
                if (values != null) {
                    if (dimension == -1) {
                        dimension = values.dimension();
                    }
                    size += values.size();
                }
                ++i;
            }
            return new MergedFloatVectorValues(dimension, size, subs);
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            ArrayList<DocValuesSub<ByteVectorValues>> subs = new ArrayList<DocValuesSub<ByteVectorValues>>();
            int i = 0;
            int dimension = -1;
            int size = 0;
            for (CodecReader reader : this.codecReaders) {
                ByteVectorValues values = reader.getByteVectorValues(field);
                subs.add(new DocValuesSub<ByteVectorValues>(values, this.docStarts[i], size));
                if (values != null) {
                    if (dimension == -1) {
                        dimension = values.dimension();
                    }
                    size += values.size();
                }
                ++i;
            }
            return new MergedByteVectorValues(dimension, size, subs);
        }

        private static int findSub(int ord, int lastSubIndex, int[] starts) {
            if (ord >= starts[lastSubIndex]) {
                if (ord >= starts[lastSubIndex + 1]) {
                    return SlowCompositeKnnVectorsReaderWrapper.binarySearchStarts(starts, ord, lastSubIndex + 1, starts.length);
                }
            } else {
                return SlowCompositeKnnVectorsReaderWrapper.binarySearchStarts(starts, ord, 0, lastSubIndex);
            }
            return lastSubIndex;
        }

        private static int binarySearchStarts(int[] starts, int ord, int from, int to) {
            int pos = Arrays.binarySearch(starts, from, to, ord);
            if (pos < 0) {
                return -2 - pos;
            }
            while (pos < starts.length - 1 && starts[pos + 1] == ord) {
                ++pos;
            }
            return pos;
        }

        class MergedFloatVectorValues
        extends FloatVectorValues {
            final int dimension;
            final int size;
            final DocValuesSub<?>[] subs;
            final MergedDocIterator<FloatVectorValues> iter;
            final int[] starts;
            int lastSubIndex;

            MergedFloatVectorValues(int dimension, int size, List<DocValuesSub<FloatVectorValues>> subs) {
                this.dimension = dimension;
                this.size = size;
                this.subs = subs.toArray(new DocValuesSub[0]);
                this.iter = new MergedDocIterator(subs);
                this.starts = new int[subs.size() + 1];
                for (int i = 0; i < subs.size(); ++i) {
                    this.starts[i] = subs.get((int)i).ordStart;
                }
                this.starts[this.starts.length - 1] = size;
            }

            @Override
            public MergedDocIterator<FloatVectorValues> iterator() {
                return this.iter;
            }

            @Override
            public int dimension() {
                return this.dimension;
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public FloatVectorValues copy() throws IOException {
                ArrayList<DocValuesSub<FloatVectorValues>> subsCopy = new ArrayList<DocValuesSub<FloatVectorValues>>();
                for (DocValuesSub<?> sub : this.subs) {
                    subsCopy.add(sub);
                }
                return new MergedFloatVectorValues(this.dimension, this.size, subsCopy);
            }

            @Override
            public float[] vectorValue(int ord) throws IOException {
                assert (ord >= 0 && ord < this.size);
                this.lastSubIndex = SlowCompositeKnnVectorsReaderWrapper.findSub(ord, this.lastSubIndex, this.starts);
                assert (this.subs[this.lastSubIndex].sub != null);
                return ((FloatVectorValues)this.subs[this.lastSubIndex].sub).vectorValue(ord - this.subs[this.lastSubIndex].ordStart);
            }
        }

        class MergedByteVectorValues
        extends ByteVectorValues {
            final int dimension;
            final int size;
            final DocValuesSub<?>[] subs;
            final MergedDocIterator<ByteVectorValues> iter;
            final int[] starts;
            int lastSubIndex;

            MergedByteVectorValues(int dimension, int size, List<DocValuesSub<ByteVectorValues>> subs) {
                this.dimension = dimension;
                this.size = size;
                this.subs = subs.toArray(new DocValuesSub[0]);
                this.iter = new MergedDocIterator(subs);
                this.starts = new int[subs.size() + 1];
                for (int i = 0; i < subs.size(); ++i) {
                    this.starts[i] = subs.get((int)i).ordStart;
                }
                this.starts[this.starts.length - 1] = size;
            }

            @Override
            public MergedDocIterator<ByteVectorValues> iterator() {
                return this.iter;
            }

            @Override
            public int dimension() {
                return this.dimension;
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public byte[] vectorValue(int ord) throws IOException {
                assert (ord >= 0 && ord < this.size);
                this.lastSubIndex = SlowCompositeKnnVectorsReaderWrapper.findSub(ord, this.lastSubIndex, this.starts);
                return ((ByteVectorValues)this.subs[this.lastSubIndex].sub).vectorValue(ord - this.subs[this.lastSubIndex].ordStart);
            }

            @Override
            public ByteVectorValues copy() throws IOException {
                ArrayList<DocValuesSub<ByteVectorValues>> newSubs = new ArrayList<DocValuesSub<ByteVectorValues>>();
                for (DocValuesSub<?> sub : this.subs) {
                    newSubs.add(sub);
                }
                return new MergedByteVectorValues(this.dimension, this.size, newSubs);
            }
        }
    }

    private static final class PointValuesSub
    extends Record {
        private final PointValues sub;
        private final int docBase;

        private PointValuesSub(PointValues sub, int docBase) {
            this.sub = Objects.requireNonNull(sub);
            this.docBase = docBase;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PointValuesSub.class, "sub;docBase", "sub", "docBase"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PointValuesSub.class, "sub;docBase", "sub", "docBase"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PointValuesSub.class, "sub;docBase", "sub", "docBase"}, this, o);
        }
    }

    private static class MergedDocIterator<T extends KnnVectorValues>
    extends KnnVectorValues.DocIndexIterator {
        final Iterator<DocValuesSub<T>> it;
        DocValuesSub<T> current;
        KnnVectorValues.DocIndexIterator currentIterator;
        int ord = -1;
        int doc = -1;

        MergedDocIterator(List<DocValuesSub<T>> subs) {
            this.it = subs.iterator();
            this.current = this.it.next();
            this.currentIterator = this.currentIterator();
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int index() {
            return this.ord;
        }

        @Override
        public int nextDoc() throws IOException {
            while (true) {
                int next;
                if (this.current.sub != null && (next = this.currentIterator.nextDoc()) != Integer.MAX_VALUE) {
                    ++this.ord;
                    this.doc = this.current.docStart + next;
                    return this.doc;
                }
                if (!this.it.hasNext()) {
                    this.ord = Integer.MAX_VALUE;
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.current = this.it.next();
                this.currentIterator = this.currentIterator();
                this.ord = this.current.ordStart - 1;
            }
        }

        private KnnVectorValues.DocIndexIterator currentIterator() {
            if (this.current.sub != null) {
                return ((KnnVectorValues)this.current.sub).iterator();
            }
            return null;
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DocValuesSub<T extends KnnVectorValues>
    extends Record {
        private final T sub;
        private final int docStart;
        private final int ordStart;

        private DocValuesSub(T sub, int docStart, int ordStart) {
            this.sub = sub;
            this.docStart = docStart;
            this.ordStart = ordStart;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DocValuesSub.class, "sub;docStart;ordStart", "sub", "docStart", "ordStart"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DocValuesSub.class, "sub;docStart;ordStart", "sub", "docStart", "ordStart"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DocValuesSub.class, "sub;docStart;ordStart", "sub", "docStart", "ordStart"}, this, o);
        }
    }
}

