/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.SingletonSortedNumericDocValues;
import guideme.internal.shaded.lucene.index.SingletonSortedSetDocValues;
import guideme.internal.shaded.lucene.index.SortedDocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.index.SortedSetDocValues;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;
import java.util.Arrays;

public final class DocValues {
    private DocValues() {
    }

    public static final BinaryDocValues emptyBinary() {
        return new BinaryDocValues(){
            private int doc = -1;

            @Override
            public int advance(int target) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                return false;
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public long cost() {
                return 0L;
            }

            @Override
            public BytesRef binaryValue() {
                assert (false);
                return null;
            }
        };
    }

    public static final NumericDocValues emptyNumeric() {
        return new NumericDocValues(){
            private int doc = -1;

            @Override
            public int advance(int target) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                return false;
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public long cost() {
                return 0L;
            }

            @Override
            public long longValue() {
                assert (false);
                return 0L;
            }
        };
    }

    public static final SortedDocValues emptySorted() {
        final BytesRef empty = new BytesRef();
        return new SortedDocValues(){
            private int doc = -1;

            @Override
            public int advance(int target) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                return false;
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public long cost() {
                return 0L;
            }

            @Override
            public int ordValue() {
                assert (false);
                return -1;
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                return empty;
            }

            @Override
            public int getValueCount() {
                return 0;
            }
        };
    }

    public static final SortedNumericDocValues emptySortedNumeric() {
        return DocValues.singleton(DocValues.emptyNumeric());
    }

    public static final SortedSetDocValues emptySortedSet() {
        return DocValues.singleton(DocValues.emptySorted());
    }

    public static SortedSetDocValues singleton(SortedDocValues dv) {
        return new SingletonSortedSetDocValues(dv);
    }

    public static SortedDocValues unwrapSingleton(SortedSetDocValues dv) {
        if (dv instanceof SingletonSortedSetDocValues) {
            return ((SingletonSortedSetDocValues)dv).getSortedDocValues();
        }
        return null;
    }

    public static NumericDocValues unwrapSingleton(SortedNumericDocValues dv) {
        if (dv instanceof SingletonSortedNumericDocValues) {
            return ((SingletonSortedNumericDocValues)dv).getNumericDocValues();
        }
        return null;
    }

    public static SortedNumericDocValues singleton(NumericDocValues dv) {
        return new SingletonSortedNumericDocValues(dv);
    }

    private static void checkField(LeafReader in, String field, DocValuesType ... expected) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field);
        if (fi != null) {
            DocValuesType actual = fi.getDocValuesType();
            throw new IllegalStateException("unexpected docvalues type " + String.valueOf((Object)actual) + " for field '" + field + "' " + (expected.length == 1 ? "(expected=" + String.valueOf((Object)expected[0]) : "(expected one of " + Arrays.toString((Object[])expected)) + "). Re-index with correct docvalues type.");
        }
    }

    public static NumericDocValues getNumeric(LeafReader reader, String field) throws IOException {
        NumericDocValues dv = reader.getNumericDocValues(field);
        if (dv == null) {
            DocValues.checkField(reader, field, DocValuesType.NUMERIC);
            return DocValues.emptyNumeric();
        }
        return dv;
    }

    public static SortedDocValues getSorted(LeafReader reader, String field) throws IOException {
        SortedDocValues dv = reader.getSortedDocValues(field);
        if (dv == null) {
            DocValues.checkField(reader, field, DocValuesType.SORTED);
            return DocValues.emptySorted();
        }
        return dv;
    }

    public static SortedSetDocValues getSortedSet(LeafReader reader, String field) throws IOException {
        SortedSetDocValues dv = reader.getSortedSetDocValues(field);
        if (dv == null) {
            SortedDocValues sorted = reader.getSortedDocValues(field);
            if (sorted == null) {
                DocValues.checkField(reader, field, DocValuesType.SORTED, DocValuesType.SORTED_SET);
                return DocValues.emptySortedSet();
            }
            dv = DocValues.singleton(sorted);
        }
        return dv;
    }

    public static boolean isCacheable(LeafReaderContext ctx, String ... fields) {
        for (String field : fields) {
            FieldInfo fi = ctx.reader().getFieldInfos().fieldInfo(field);
            if (fi == null || fi.getDocValuesGen() <= -1L) continue;
            return false;
        }
        return true;
    }
}

