/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.standard;

import guideme.internal.shaded.lucene.analysis.Tokenizer;
import guideme.internal.shaded.lucene.analysis.standard.StandardTokenizerImpl;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.TypeAttribute;
import java.io.IOException;

public final class StandardTokenizer
extends Tokenizer {
    private StandardTokenizerImpl scanner;
    public static final String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<NUM>", "<SOUTHEAST_ASIAN>", "<IDEOGRAPHIC>", "<HIRAGANA>", "<KATAKANA>", "<HANGUL>", "<EMOJI>"};
    private int skippedPositions;
    private int maxTokenLength = 255;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    public void setMaxTokenLength(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("maxTokenLength must be greater than zero");
        }
        if (length > 0x100000) {
            throw new IllegalArgumentException("maxTokenLength may not exceed 1048576");
        }
        if (length != this.maxTokenLength) {
            this.maxTokenLength = length;
            this.scanner.setBufferSize(length);
        }
    }

    public StandardTokenizer() {
        this.init();
    }

    private void init() {
        this.scanner = new StandardTokenizerImpl(this.input);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        this.skippedPositions = 0;
        int tokenType;
        while ((tokenType = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= this.maxTokenLength) {
                this.posIncrAtt.setPositionIncrement(this.skippedPositions + 1);
                this.scanner.getText(this.termAtt);
                int start = this.scanner.yychar();
                this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(start + this.termAtt.length()));
                this.typeAtt.setType(TOKEN_TYPES[tokenType]);
                return true;
            }
            ++this.skippedPositions;
        }
        return false;
    }

    @Override
    public final void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.scanner.yychar() + this.scanner.yylength());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.scanner.yyreset(this.input);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.scanner.yyreset(this.input);
        this.skippedPositions = 0;
    }
}

