/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import guideme.internal.screen.ScaledGuiGraphics;
import guideme.render.RenderContext;
import guideme.render.SimpleRenderContext;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class IndepentScaleScreen
extends Screen {
    private double effectiveScale = this.calculateEffectiveScale();

    protected IndepentScaleScreen(Component title) {
        super(title);
    }

    protected abstract float calculateEffectiveScale();

    protected void init() {
        super.init();
        this.width = this.toVirtual(Minecraft.getInstance().getWindow().getGuiScaledWidth());
        this.height = this.toVirtual(Minecraft.getInstance().getWindow().getGuiScaledHeight());
    }

    public final void resize(Minecraft minecraft, int width, int height) {
        this.effectiveScale = this.calculateEffectiveScale();
        super.resize(minecraft, this.toVirtual(width), this.toVirtual(height));
    }

    public final void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ScaledGuiGraphics scaledGraphics = new ScaledGuiGraphics(Minecraft.getInstance(), guiGraphics.pose(), guiGraphics.bufferSource, (float)this.effectiveScale);
        SimpleRenderContext renderContext = new SimpleRenderContext(guiGraphics);
        scaledGraphics.pose().pushPose();
        scaledGraphics.pose().scale((float)this.effectiveScale, (float)this.effectiveScale, (float)this.effectiveScale);
        this.scaledRender(scaledGraphics, renderContext, this.toVirtual(mouseX), this.toVirtual(mouseY), partialTick);
        if (this.deferredTooltipRendering != null) {
            scaledGraphics.renderTooltip(this.font, this.deferredTooltipRendering.tooltip(), this.deferredTooltipRendering.positioner(), this.toVirtual(mouseX), this.toVirtual(mouseY));
            this.deferredTooltipRendering = null;
        }
        scaledGraphics.pose().popPose();
    }

    protected void scaledRender(GuiGraphics guiGraphics, RenderContext context, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public final Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        return super.getChildAt(this.toVirtual(mouseX), this.toVirtual(mouseY));
    }

    protected final Optional<GuiEventListener> getScaledChildAt(double mouseX, double mouseY) {
        return super.getChildAt(mouseX, mouseY);
    }

    public final boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.scaledMouseClicked(this.toVirtual(mouseX), this.toVirtual(mouseY), button);
    }

    protected boolean scaledMouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public final boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.scaledMouseReleased(this.toVirtual(mouseX), this.toVirtual(mouseY), button);
    }

    protected boolean scaledMouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public final boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.scaledMouseDragged(this.toVirtual(mouseX), this.toVirtual(mouseY), button, dragX, dragY);
    }

    protected boolean scaledMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public final boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.scaledMouseScrolled(this.toVirtual(mouseX), this.toVirtual(mouseY), scrollX, scrollY);
    }

    protected boolean scaledMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public final void mouseMoved(double mouseX, double mouseY) {
        this.scaledMouseMoved(this.toVirtual(mouseX), this.toVirtual(mouseY));
    }

    protected void scaledMouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
    }

    protected final int toVirtual(int value) {
        return (int)Math.round((double)value / this.effectiveScale);
    }

    protected final double toVirtual(double value) {
        return value / this.effectiveScale;
    }
}

