/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.document.LytRect;
import guideme.document.block.LytBox;
import guideme.document.block.LytSlot;
import guideme.layout.LayoutContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public class LytItemGrid
extends LytBox {
    private final List<LytSlot> slots = new ArrayList<LytSlot>();

    public LytItemGrid() {
        this.setPadding(5);
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        int cols = Math.max(1, availableWidth / 18);
        int rows = (this.slots.size() + cols - 1) / cols;
        for (int i = 0; i < this.slots.size(); ++i) {
            int slotX = i % cols;
            int slotY = i / cols;
            this.slots.get(i).layout(context, x + slotX * 18, y + slotY * 18, availableWidth);
        }
        return new LytRect(x, y, cols * 18, rows * 18);
    }

    public void addItem(SlotDisplay display) {
        LytSlot slot = new LytSlot(display);
        this.slots.add(slot);
        this.append(slot);
    }

    public void addItem(Item item) {
        LytSlot slot = new LytSlot(item.getDefaultInstance());
        this.slots.add(slot);
        this.append(slot);
    }

    public void addItem(ItemStack stack) {
        LytSlot slot = new LytSlot(stack);
        this.slots.add(slot);
        this.append(slot);
    }
}

