/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.document.LytRect;
import guideme.document.block.AlignItems;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBlockContainer;
import guideme.document.block.LytNode;
import guideme.document.flow.LytFlowContainer;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowInlineBlock;
import guideme.layout.LayoutContext;
import guideme.layout.Layouts;
import guideme.render.RenderContext;
import guideme.render.SimpleRenderContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.Nullable;

public class LytDocument
extends LytNode
implements LytBlockContainer {
    private final List<LytBlock> blocks = new ArrayList<LytBlock>();
    @Nullable
    private Layout layout;
    @Nullable
    private HitTestResult hoveredElement;

    public int getAvailableWidth() {
        return this.layout != null ? this.layout.availableWidth() : 0;
    }

    public int getContentHeight() {
        return this.layout != null ? this.layout.contentHeight() : 0;
    }

    public List<LytBlock> getBlocks() {
        return this.blocks;
    }

    public List<LytBlock> getChildren() {
        return this.blocks;
    }

    @Override
    public LytRect getBounds() {
        return this.layout != null ? new LytRect(0, 0, this.layout.availableWidth, this.layout.contentHeight) : null;
    }

    @Override
    public void removeChild(LytNode node) {
        if (node instanceof LytBlock) {
            LytBlock block = (LytBlock)node;
            if (block.parent == this) {
                block.parent = null;
            }
            this.blocks.remove(block);
            this.invalidateLayout();
        }
    }

    @Override
    public void append(LytBlock block) {
        if (block.parent != null) {
            block.parent.removeChild(block);
        }
        block.parent = this;
        this.blocks.add(block);
        this.invalidateLayout();
    }

    public void clearContent() {
        for (LytBlock block : this.blocks) {
            block.parent = null;
        }
        this.blocks.clear();
        this.invalidateLayout();
    }

    public boolean hasLayout() {
        return this.layout != null;
    }

    public void invalidateLayout() {
        this.layout = null;
    }

    public void updateLayout(LayoutContext context, int availableWidth) {
        if (this.layout != null && this.layout.availableWidth == availableWidth) {
            return;
        }
        this.layout = this.createLayout(context, availableWidth);
    }

    private Layout createLayout(LayoutContext context, int availableWidth) {
        LytRect bounds = Layouts.verticalLayout(context, this.blocks, 0, 0, availableWidth, 5, 5, 5, 5, 0, AlignItems.START);
        return new Layout(availableWidth, bounds.height());
    }

    @Deprecated(forRemoval=true)
    public void render(SimpleRenderContext context) {
        this.render((RenderContext)context);
    }

    public void render(RenderContext context) {
        for (LytBlock block : this.blocks) {
            if (block.isCulled(context.viewport())) continue;
            block.render(context);
        }
    }

    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
        for (LytBlock block : this.blocks) {
            if (!context.intersectsViewport(block.getBounds())) continue;
            block.renderBatch(context, buffers);
        }
    }

    public HitTestResult getHoveredElement() {
        return this.hoveredElement;
    }

    public void setHoveredElement(HitTestResult hoveredElement) {
        if (!Objects.equals(hoveredElement, this.hoveredElement)) {
            if (this.hoveredElement != null) {
                this.hoveredElement.node.onMouseLeave();
            }
            this.hoveredElement = hoveredElement;
            if (this.hoveredElement != null) {
                this.hoveredElement.node.onMouseEnter(hoveredElement.content());
            }
        }
    }

    public HitTestResult pick(int x, int y) {
        return LytDocument.pick(this, x, y);
    }

    private static HitTestResult pick(LytNode root, int x, int y) {
        LytNode node = root.pickNode(x, y);
        if (node != null) {
            LytFlowInlineBlock inlineBlock;
            LytFlowContainer container;
            LytFlowContent content = null;
            if (node instanceof LytFlowContainer && (content = (container = (LytFlowContainer)((Object)node)).pickContent(x, y)) instanceof LytFlowInlineBlock && (inlineBlock = (LytFlowInlineBlock)content).getBlock() != null) {
                return LytDocument.pick(inlineBlock.getBlock(), x, y);
            }
            return new HitTestResult(node, content);
        }
        return null;
    }

    @Override
    public void onMouseEnter(@Nullable LytFlowContent hoveredContent) {
    }

    public record Layout(int availableWidth, int contentHeight) {
    }

    public record HitTestResult(LytNode node, @Nullable LytFlowContent content) {
    }
}

