/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.State;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactorySpace;

public final class CodeIndented {
    public static final Construct codeIndented = new Construct();
    public static final Construct indentedContent;

    private CodeIndented() {
    }

    static {
        CodeIndented.codeIndented.name = "codeIndented";
        CodeIndented.codeIndented.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
        indentedContent = new Construct();
        CodeIndented.indentedContent.tokenize = (context, effects, ok, nok) -> new IndentedContentStateMachine(context, effects, ok, nok)::start;
        CodeIndented.indentedContent.partial = true;
    }

    private static class IndentedContentStateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;

        public IndentedContentStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            if (this.context.isOnLazyLine()) {
                return this.nok.step(code);
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.effects.enter("lineEnding");
                this.effects.consume(code);
                this.effects.exit("lineEnding");
                return this::start;
            }
            return FactorySpace.create(this.effects, this::afterPrefix, "linePrefix", 5).step(code);
        }

        private State afterPrefix(int code) {
            Tokenizer.Event tail = this.context.getLastEvent();
            return tail != null && tail.token().type.equals("linePrefix") && tail.context().sliceSerialize(tail.token(), true).length() >= 4 ? this.ok.step(code) : (CharUtil.markdownLineEnding(code) ? this.start(code) : this.nok.step(code));
        }
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            this.effects.enter("codeIndented");
            return FactorySpace.create(this.effects, this::afterStartPrefix, "linePrefix", 5).step(code);
        }

        private State afterStartPrefix(int code) {
            Tokenizer.Event tail = this.context.getLastEvent();
            return tail != null && tail.token().type.equals("linePrefix") && tail.context().sliceSerialize(tail.token(), true).length() >= 4 ? this.afterPrefix(code) : this.nok.step(code);
        }

        private State afterPrefix(int code) {
            if (code == Integer.MIN_VALUE) {
                return this.after(code);
            }
            if (CharUtil.markdownLineEnding(code)) {
                return this.effects.attempt.hook(indentedContent, this::afterPrefix, this::after).step(code);
            }
            this.effects.enter("codeFlowValue");
            return this.content(code);
        }

        private State content(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                this.effects.exit("codeFlowValue");
                return this.afterPrefix(code);
            }
            this.effects.consume(code);
            return this::content;
        }

        private State after(int code) {
            this.effects.exit("codeIndented");
            return this.ok.step(code);
        }
    }
}

