/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.State;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;

public final class AutoLink {
    public static final Construct autolink = new Construct();

    static {
        AutoLink.autolink.name = "autolink";
        AutoLink.autolink.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
    }

    static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        int size = 1;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 60, "expected `<`");
            this.effects.enter("autolink");
            this.effects.enter("autolinkMarker");
            this.effects.consume(code);
            this.effects.exit("autolinkMarker");
            this.effects.enter("autolinkProtocol");
            return this::open;
        }

        private State open(int code) {
            if (CharUtil.asciiAlpha(code)) {
                this.effects.consume(code);
                return this::schemeOrEmailAtext;
            }
            return this.emailAtext(code);
        }

        private State schemeOrEmailAtext(int code) {
            return code == 43 || code == 45 || code == 46 || CharUtil.asciiAlphanumeric(code) ? this.schemeInsideOrEmailAtext(code) : this.emailAtext(code);
        }

        private State schemeInsideOrEmailAtext(int code) {
            if (code == 58) {
                this.effects.consume(code);
                return this::urlInside;
            }
            if ((code == 43 || code == 45 || code == 46 || CharUtil.asciiAlphanumeric(code)) && this.size++ < 32) {
                this.effects.consume(code);
                return this::schemeInsideOrEmailAtext;
            }
            return this.emailAtext(code);
        }

        private State urlInside(int code) {
            if (code == 62) {
                this.effects.exit("autolinkProtocol");
                return this.end(code);
            }
            if (code == Integer.MIN_VALUE || code == 32 || code == 60 || CharUtil.asciiControl(code)) {
                return this.nok.step(code);
            }
            this.effects.consume(code);
            return this::urlInside;
        }

        private State emailAtext(int code) {
            if (code == 64) {
                this.effects.consume(code);
                this.size = 0;
                return this::emailAtSignOrDot;
            }
            if (CharUtil.asciiAtext(code)) {
                this.effects.consume(code);
                return this::emailAtext;
            }
            return this.nok.step(code);
        }

        private State emailAtSignOrDot(int code) {
            return CharUtil.asciiAlphanumeric(code) ? this.emailLabel(code) : this.nok.step(code);
        }

        private State emailLabel(int code) {
            if (code == 46) {
                this.effects.consume(code);
                this.size = 0;
                return this::emailAtSignOrDot;
            }
            if (code == 62) {
                this.effects.exit((String)"autolinkProtocol").type = "autolinkEmail";
                return this.end(code);
            }
            return this.emailValue(code);
        }

        private State emailValue(int code) {
            if ((code == 45 || CharUtil.asciiAlphanumeric(code)) && this.size++ < 63) {
                this.effects.consume(code);
                return code == 45 ? this::emailValue : this::emailLabel;
            }
            return this.nok.step(code);
        }

        private State end(int code) {
            Assert.check(code == 62, "expected `>`");
            this.effects.enter("autolinkMarker");
            this.effects.consume(code);
            this.effects.exit("autolinkMarker");
            this.effects.exit("autolink");
            return this.ok;
        }
    }
}

